/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.vpnconnection.model.transform;

import com.nifty.cloud.sdk.tools.DateUtils;
import com.nifty.cloud.sdk.vpnconnection.model.NiftyIpsecConfiguration;
import com.nifty.cloud.sdk.vpnconnection.model.NiftyTunnel;
import com.nifty.cloud.sdk.vpnconnection.model.VpnConnection;
import com.nifty.cloud.sdk.vpnconnection.model.VpnConnectionOptions;
import com.nifty.cloud.sdk.vpnconnection.model.VpnStaticRoutes;
import com.nifty.cloud.sdk.vpnconnection.model.transform.NiftyIpsecConfigurationConverter;
import com.nifty.cloud.sdk.vpnconnection.model.transform.NiftyTunnelConverter;
import com.nifty.cloud.sdk.vpnconnection.model.transform.OptionsConverter;
import com.nifty.cloud.sdk.vpnconnection.model.transform.RoutesConverter;
import com.nifty.cloud.sdk.vpnconnection.model.transform.TagSetConverter;
import com.nifty.cloud.sdk.vpnconnection.model.transform.VgwTelemetryConverter;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.ArrayList;
import java.util.List;

public class VpnConnectionSetConverter
implements Converter {
    private static final String ELEMENT_VPN_CONNECTION_ID = "vpnConnectionId";
    private static final String ELEMENT_STATE = "state";
    private static final String ELEMENT_CUSTOMER_GATEWAY_CONFIGURATION = "customerGatewayConfiguration";
    private static final String ELEMENT_TYPE = "type";
    private static final String ELEMENT_VPN_GATEWAY_ID = "vpnGatewayId";
    private static final String ELEMENT_NIFTY_VPN_GATEWAY_NAME = "niftyVpnGatewayName";
    private static final String ELEMENT_CUSTOMER_GATEWAY_ID = "customerGatewayId";
    private static final String ELEMENT_NIFTY_CUSTOMER_GATEWAY_NAME = "niftyCustomerGatewayName";
    private static final String ELEMENT_TAG_SET = "tagSet";
    private static final String ELEMENT_VGW_TELEMETRY = "vgwTelemetry";
    private static final String ELEMENT_OPTIONS = "options";
    private static final String ELEMENT_ROUTES = "routes";
    private static final String ELEMENT_NIFTY_VPN_CONNECTION_DESCRIPTION = "niftyVpnConnectionDescription";
    private static final String ELEMENT_CREATED_TIME = "createdTime";
    private static final String ELEMENT_NIFTY_TUNNEL = "niftyTunnel";
    private static final String ELEMENT_NIFTY_IPSEC_CONFIGURATION = "niftyIpsecConfiguration";

    public boolean canConvert(Class clazz) {
        Class<?>[] interfaces;
        for (Class<?> i : interfaces = clazz.getInterfaces()) {
            if (i != List.class) continue;
            return true;
        }
        return false;
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        ArrayList<VpnConnection> vpnConnections = new ArrayList<VpnConnection>();
        TagSetConverter tagSetConverter = new TagSetConverter();
        VgwTelemetryConverter vgwTelemetryConverter = new VgwTelemetryConverter();
        OptionsConverter optionsConverter = new OptionsConverter();
        RoutesConverter routesConverter = new RoutesConverter();
        NiftyTunnelConverter niftyTunnelConverter = new NiftyTunnelConverter();
        NiftyIpsecConfigurationConverter niftyIpsecConfigurationConverter = new NiftyIpsecConfigurationConverter();
        String name = null;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            VpnConnection vpnConnection = new VpnConnection();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                name = reader.getNodeName();
                if (name.equals(ELEMENT_VPN_CONNECTION_ID)) {
                    vpnConnection.setVpnConnectionId(reader.getValue());
                } else if (name.equals(ELEMENT_STATE)) {
                    vpnConnection.setState(reader.getValue());
                } else if (name.equals(ELEMENT_CUSTOMER_GATEWAY_CONFIGURATION)) {
                    vpnConnection.setCustomerGatewayConfiguration(reader.getValue());
                } else if (name.equals(ELEMENT_TYPE)) {
                    vpnConnection.setType(reader.getValue());
                } else if (name.equals(ELEMENT_VPN_GATEWAY_ID)) {
                    vpnConnection.setVpnGatewayId(reader.getValue());
                } else if (name.equals(ELEMENT_NIFTY_VPN_GATEWAY_NAME)) {
                    vpnConnection.setNiftyVpnGatewayName(reader.getValue());
                } else if (name.equals(ELEMENT_CUSTOMER_GATEWAY_ID)) {
                    vpnConnection.setCustomerGatewayId(reader.getValue());
                } else if (name.equals(ELEMENT_NIFTY_CUSTOMER_GATEWAY_NAME)) {
                    vpnConnection.setNiftyCustomerGatewayName(reader.getValue());
                } else if (name.equals(ELEMENT_TAG_SET)) {
                    vpnConnection.setTagSet((List)tagSetConverter.unmarshal(reader, context));
                } else if (name.equals(ELEMENT_VGW_TELEMETRY)) {
                    vpnConnection.setVgwTelemetries((List)vgwTelemetryConverter.unmarshal(reader, context));
                } else if (name.equals(ELEMENT_OPTIONS)) {
                    vpnConnection.setOptions((VpnConnectionOptions)optionsConverter.unmarshal(reader, context));
                } else if (name.equals(ELEMENT_ROUTES)) {
                    vpnConnection.setRoutes((VpnStaticRoutes)routesConverter.unmarshal(reader, context));
                } else if (name.equals(ELEMENT_NIFTY_VPN_CONNECTION_DESCRIPTION)) {
                    vpnConnection.setNiftyVpnConnectionDescription(reader.getValue());
                } else if (name.equals(ELEMENT_CREATED_TIME)) {
                    vpnConnection.setCreatedTime(DateUtils.toDate(reader.getValue()));
                } else if (name.equals(ELEMENT_NIFTY_TUNNEL)) {
                    vpnConnection.setNiftyTunnel((NiftyTunnel)niftyTunnelConverter.unmarshal(reader, context));
                } else if (name.equals(ELEMENT_NIFTY_IPSEC_CONFIGURATION)) {
                    vpnConnection.setNiftyIpsecConfiguration((NiftyIpsecConfiguration)niftyIpsecConfigurationConverter.unmarshal(reader, context));
                }
                reader.moveUp();
            }
            reader.moveUp();
            vpnConnections.add(vpnConnection);
        }
        return vpnConnections;
    }

    public void marshal(Object paramObject, HierarchicalStreamWriter paramHierarchicalStreamWriter, MarshallingContext paramMarshallingContext) {
    }
}

