/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.upload.model.transform;

import com.nifty.cloud.sdk.tools.DateUtils;
import com.nifty.cloud.sdk.upload.model.ImportInstance;
import com.nifty.cloud.sdk.upload.model.Upload;
import com.nifty.cloud.sdk.upload.model.transform.ImportInstanceConverter;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.ArrayList;
import java.util.List;

public class UploadSetConverter
implements Converter {
    private static final String ELEMENT_CONVERSION_TASK_ID = "conversionTaskId";
    private static final String ELEMENT_EXPIRATION_TIME = "expirationTime";
    private static final String ELEMENT_IMPORT_INSTANCE = "importInstance";

    public boolean canConvert(Class clazz) {
        for (Class<?> i : clazz.getInterfaces()) {
            if (i != List.class) continue;
            return true;
        }
        return false;
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        ArrayList<Upload> list = new ArrayList<Upload>();
        ImportInstanceConverter converter = new ImportInstanceConverter();
        String name = null;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            Upload upload = new Upload();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                name = reader.getNodeName();
                if (ELEMENT_CONVERSION_TASK_ID.equals(name)) {
                    upload.setConversionTaskId(reader.getValue());
                } else if (ELEMENT_EXPIRATION_TIME.equals(name)) {
                    upload.setExpirationTime(DateUtils.toDate(reader.getValue()));
                } else if (ELEMENT_IMPORT_INSTANCE.equals(name)) {
                    upload.setImportInstance((ImportInstance)converter.unmarshal(reader, context));
                }
                reader.moveUp();
            }
            list.add(upload);
            reader.moveUp();
        }
        return list;
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
    }
}

