/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.upload.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.upload.UploadCallback;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public abstract class UploadRequest
implements Request {
    private File file;
    private long offset;
    private long position;
    private int partSize = 0x800000;
    private List<UploadCallback> callbacks;

    public UploadRequest() {
    }

    public UploadRequest(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public UploadRequest withFile(File file) {
        this.setFile(file);
        return this;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public UploadRequest withOffset(long offset) {
        this.setOffset(offset);
        return this;
    }

    public int getPartSize() {
        return this.partSize;
    }

    public void setPartSize(int partSize) {
        this.partSize = partSize;
    }

    public UploadRequest withPartSize(int partSize) {
        this.setPartSize(partSize);
        return this;
    }

    public long getPosition() {
        return this.position;
    }

    public void setPosition(long position) {
        this.position = position;
    }

    public UploadRequest withPosition(long position) {
        this.setPosition(position);
        return this;
    }

    public List<UploadCallback> getCallbacks() {
        return this.callbacks;
    }

    public void setCallbacks(List<UploadCallback> callbacks) {
        this.callbacks = callbacks;
    }

    public UploadRequest withCallbacks(Collection<UploadCallback> callbacks) {
        if (this.callbacks == null) {
            this.callbacks = new ArrayList<UploadCallback>();
        }
        if (callbacks != null) {
            this.callbacks.addAll(callbacks);
        }
        return this;
    }

    public UploadRequest withCallbacks(UploadCallback ... callbacks) {
        if (this.callbacks == null) {
            this.callbacks = new ArrayList<UploadCallback>();
        }
        for (UploadCallback callback : callbacks) {
            this.callbacks.add(callback);
        }
        return this;
    }

    public void addCallback(UploadCallback callback) {
        if (this.callbacks == null) {
            this.callbacks = new ArrayList<UploadCallback>();
        }
        this.callbacks.add(callback);
    }

    public boolean removeCallback(UploadCallback callback) {
        if (this.callbacks == null || this.callbacks.isEmpty()) {
            return false;
        }
        return this.callbacks.remove(callback);
    }

    public void notifyProgress(long partSize, long sent) {
        if (this.callbacks == null || this.callbacks.isEmpty()) {
            return;
        }
        for (UploadCallback callback : this.callbacks) {
            callback.notifyProgress(partSize, sent);
        }
    }

    public abstract void getHeaders(Map<String, String> var1, int var2);
}

