/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.upload.model;

import com.nifty.cloud.sdk.tools.HttpHeaderUtils;
import com.nifty.cloud.sdk.upload.model.UploadResult;
import org.apache.http.Header;
import org.apache.http.HttpResponse;

public class LargeSizeUploadResult
extends UploadResult {
    private Long partSize;
    private Integer timeout;
    private Integer bufsize;

    @Override
    public void applyResponse(HttpResponse response) {
        this.setResponseXml("");
        Header header = HttpHeaderUtils.getCondensedHeader(response, "x-nifty-upload-applet-blocksize");
        this.setPartSize(header != null ? new Long(header.getValue()) : null);
        header = HttpHeaderUtils.getCondensedHeader(response, "x-nifty-upload-applet-timeout");
        this.setTimeout(header != null ? new Integer(header.getValue()) : null);
        header = HttpHeaderUtils.getCondensedHeader(response, "x-nifty-upload-applet-socketbufsize");
        this.setBufsize(header != null ? new Integer(header.getValue()) : null);
        header = HttpHeaderUtils.getCondensedHeader(response, "x-nifty-upload-next-position");
        this.setPosition(header != null ? new Long(header.getValue()) : null);
        header = HttpHeaderUtils.getCondensedHeader(response, "x-nifty-upload-result-msg");
        if (header == null) {
            this.setErrorMessage("Failed to uploading, please try again shortly.");
        } else {
            String message = header.getValue();
            if ("ok.".equals(message)) {
                this.setErrorMessage(null);
            } else {
                header = HttpHeaderUtils.getCondensedHeader(response, "x-nifty-upload-result-code");
                if (header != null) {
                    message = message + " (result code=" + header.getValue() + ')';
                }
                this.setErrorMessage(message);
            }
        }
    }

    public Long getPartSize() {
        return this.partSize;
    }

    public void setPartSize(Long partSize) {
        this.partSize = partSize;
    }

    public LargeSizeUploadResult withPartSize(Long partSize) {
        this.setPartSize(partSize);
        return this;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public LargeSizeUploadResult withTimeout(Integer timeout) {
        this.setTimeout(timeout);
        return this;
    }

    public Integer getBufsize() {
        return this.bufsize;
    }

    public void setBufsize(Integer bufsize) {
        this.bufsize = bufsize;
    }

    public LargeSizeUploadResult withBufsize(Integer bufsize) {
        this.setBufsize(bufsize);
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[partSize=");
        builder.append(this.partSize);
        builder.append(", timeout=");
        builder.append(this.timeout);
        builder.append(", bufsize=");
        builder.append(this.bufsize);
        builder.append("]");
        return builder.toString();
    }
}

