/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.upload.model;

import com.nifty.cloud.sdk.NiftyClientException;
import com.nifty.cloud.sdk.upload.model.Operation;
import com.nifty.cloud.sdk.upload.model.UploadRequest;
import java.io.File;
import java.util.Map;

public class LargeSizeUploadRequest
extends UploadRequest {
    private String conversionTaskId;
    private Operation operation = Operation.appletinit;

    public LargeSizeUploadRequest() {
    }

    public LargeSizeUploadRequest(File file) {
        super(file);
    }

    @Override
    public void getHeaders(Map<String, String> headerMap, int partSize) {
        headerMap.clear();
        switch (this.operation) {
            case appletinit: {
                break;
            }
            case query: {
                headerMap.put("x-nifty-upload-filename", this.getFile().getName());
                break;
            }
            case upload: {
                headerMap.put("x-nifty-upload-next-position", Long.toString(this.getPosition()));
                headerMap.put("x-nifty-upload-block-size", Long.toString(partSize));
                headerMap.put("x-nifty-upload-file-size", Long.toString(this.getFile().length()));
                headerMap.put("x-nifty-upload-filename", this.getFile().getName());
            }
        }
        headerMap.put("x-nifty-upload-operation", this.operation.toString());
        headerMap.put("x-nifty-upload-id", this.conversionTaskId);
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void setOperation(Operation operation) {
        if (operation == null) {
            throw new NiftyClientException("Operation cannot be null.");
        }
        this.operation = operation;
    }

    public LargeSizeUploadRequest withOperation(Operation operation) {
        this.setOperation(operation);
        return this;
    }

    public String getConversionTaskId() {
        return this.conversionTaskId;
    }

    public void setConversionTaskId(String conversionTaskId) {
        this.conversionTaskId = conversionTaskId;
    }

    public LargeSizeUploadRequest withConversionTaskId(String conversionTaskId) {
        this.setConversionTaskId(conversionTaskId);
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[conversionTaskId=");
        builder.append(this.conversionTaskId);
        builder.append(", operation=");
        builder.append((Object)this.operation);
        builder.append("]");
        return builder.toString();
    }
}

