/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.upload;

import com.nifty.cloud.sdk.BaseClient;
import com.nifty.cloud.sdk.ClientConfiguration;
import com.nifty.cloud.sdk.auth.Credentials;
import com.nifty.cloud.sdk.upload.NiftyUpload;
import com.nifty.cloud.sdk.upload.model.CancelUploadRequest;
import com.nifty.cloud.sdk.upload.model.CancelUploadResult;
import com.nifty.cloud.sdk.upload.model.DescribeUploadsRequest;
import com.nifty.cloud.sdk.upload.model.DescribeUploadsResult;
import com.nifty.cloud.sdk.upload.model.LargeSizeUploadRequest;
import com.nifty.cloud.sdk.upload.model.LargeSizeUploadResult;
import com.nifty.cloud.sdk.upload.model.Operation;

public class NiftyUploadClient
extends BaseClient
implements NiftyUpload {
    public NiftyUploadClient(Credentials credential) {
        super(credential, new ClientConfiguration());
    }

    public NiftyUploadClient(Credentials credential, ClientConfiguration configuration) {
        super(credential, configuration);
    }

    @Override
    public LargeSizeUploadResult largeSizeUpload(LargeSizeUploadRequest request) {
        long position;
        if (request.getPartSize() == 0) {
            request.setPartSize(this.client.getConfig().getUploadBlockSize() * 1024 * 1024);
        }
        request.setOperation(Operation.appletinit);
        LargeSizeUploadResult result = (LargeSizeUploadResult)this.client.processLargeSizeUpload(request, LargeSizeUploadResult.class);
        request.setOperation(Operation.query);
        result = (LargeSizeUploadResult)this.client.processLargeSizeUpload(request, LargeSizeUploadResult.class);
        long l = position = result.getPosition() != null ? result.getPosition() : 0L;
        if (position > 0L) {
            request.notifyProgress(position, 0L);
        }
        request.setOffset(position);
        request.setPosition(position);
        request.setOperation(Operation.upload);
        return (LargeSizeUploadResult)this.client.executeLargeSizeUpload(request, LargeSizeUploadResult.class);
    }

    @Override
    public DescribeUploadsResult describeUploads(DescribeUploadsRequest request) {
        return (DescribeUploadsResult)this.client.execute(request, DescribeUploadsResult.class);
    }

    @Override
    public CancelUploadResult cancelUpload(CancelUploadRequest request) {
        return (CancelUploadResult)this.client.execute(request, CancelUploadResult.class);
    }

    public void setUploadEndpoint(String uploadEndpoint) {
        this.client.setUploadEndpoint(uploadEndpoint);
    }
}

