/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.upload;

import com.nifty.cloud.sdk.ClientConfiguration;
import com.nifty.cloud.sdk.auth.Credentials;
import com.nifty.cloud.sdk.upload.NiftyUploadAsync;
import com.nifty.cloud.sdk.upload.NiftyUploadClient;
import com.nifty.cloud.sdk.upload.model.CancelUploadRequest;
import com.nifty.cloud.sdk.upload.model.CancelUploadResult;
import com.nifty.cloud.sdk.upload.model.DescribeUploadsRequest;
import com.nifty.cloud.sdk.upload.model.DescribeUploadsResult;
import com.nifty.cloud.sdk.upload.model.LargeSizeUploadRequest;
import com.nifty.cloud.sdk.upload.model.LargeSizeUploadResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class NiftyUploadAsyncClient
extends NiftyUploadClient
implements NiftyUploadAsync {
    protected ExecutorService executorService = null;

    public NiftyUploadAsyncClient(Credentials credential) {
        this(credential, Executors.newCachedThreadPool());
    }

    public NiftyUploadAsyncClient(Credentials credential, ClientConfiguration configuration) {
        this(credential, configuration, Executors.newCachedThreadPool());
    }

    public NiftyUploadAsyncClient(Credentials credential, ExecutorService executorService) {
        super(credential);
        this.executorService = executorService;
    }

    public NiftyUploadAsyncClient(Credentials credential, ClientConfiguration configuration, ExecutorService executorService) {
        super(credential, configuration);
        this.executorService = executorService;
    }

    @Override
    public Future<LargeSizeUploadResult> largeSizeUploadAsync(final LargeSizeUploadRequest request) {
        return this.executorService.submit(new Callable<LargeSizeUploadResult>(){

            @Override
            public LargeSizeUploadResult call() {
                return NiftyUploadAsyncClient.this.largeSizeUpload(request);
            }
        });
    }

    @Override
    public Future<DescribeUploadsResult> describeUploadsAsync(final DescribeUploadsRequest request) {
        return this.executorService.submit(new Callable<DescribeUploadsResult>(){

            @Override
            public DescribeUploadsResult call() {
                return NiftyUploadAsyncClient.this.describeUploads(request);
            }
        });
    }

    @Override
    public Future<CancelUploadResult> cancelUploadAsync(final CancelUploadRequest request) {
        return this.executorService.submit(new Callable<CancelUploadResult>(){

            @Override
            public CancelUploadResult call() {
                return NiftyUploadAsyncClient.this.cancelUpload(request);
            }
        });
    }
}

