/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.tools;

import com.nifty.cloud.sdk.NiftyClientException;
import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Query;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class QueryStringGenarator
extends TreeMap<String, String> {
    private static final long serialVersionUID = 1L;
    private static final String SEPARETOR = ".";
    private static final String PLUS_SIGN = "\\+";
    private static final String ENCODE_PLUS_SIGN = "%20";
    private static final String ASTERISK_SIGN = "\\*";
    private static final String ENCODE_ASTERISK_SIGN = "%2A";
    private static final String TILDE_SIGN = "~";
    private static final String ENCODE_TILDE_SIGN = "%7E";
    private static final String SLASH_SIGN = "\\/";
    private static final String ENCODE_SLASH_SIGN = "%2F";
    private static final Pattern PLUS_PATTERN = Pattern.compile("\\+");
    private static final Pattern ASTERISK_PATTERN = Pattern.compile("\\*");
    private static final Pattern TILDE_PATTERN = Pattern.compile("%7E");
    private static final Pattern SLASH_PATTERN = Pattern.compile("%2F");

    public void parseRequest(Request request) {
        this.parse("", request);
    }

    private void parse(String name, Object obj) {
        Method[] methods;
        if (obj == null) {
            return;
        }
        Query query = null;
        for (Method method : methods = obj.getClass().getMethods()) {
            query = method.getAnnotation(Query.class);
            if (query == null) continue;
            Object value = null;
            try {
                value = method.invoke(obj, new Object[0]);
            }
            catch (Exception e) {
                throw new NiftyClientException(e);
            }
            if (value == null || value instanceof List && ((List)value).size() == 0) {
                if (!query.require()) continue;
                String queryName = query.alias().equals("") ? query.name() : query.alias();
                throw new NiftyClientException(queryName + " is required.");
            }
            if (this.useToString(value)) {
                if (query.reverseSequence()) {
                    this.put(this.exclusionSequence(name) + query.name(), this.ejectSequence(name), value);
                    continue;
                }
                this.put(name, query.name(), value);
                continue;
            }
            if (value instanceof List) {
                int i = 1;
                for (Object item : (List)value) {
                    if (this.useToString(item)) {
                        this.put(name, this.addPostfix(query.name(), i), item);
                    } else {
                        this.parse(this.addPrefix(name, this.addPostfix(query.name(), i)), item);
                    }
                    ++i;
                }
                continue;
            }
            if (query.reverseSequence()) {
                this.parse(query.name() + name, value);
                continue;
            }
            this.parse(this.addPrefix(name, query.name()), value);
        }
    }

    public String toQueryString() {
        return this.toQueryString(false);
    }

    public String toQueryString(boolean tilde) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.entrySet()) {
            String name = QueryStringGenarator.urlEncode((String)entry.getKey(), false, tilde);
            String value = QueryStringGenarator.urlEncode((String)entry.getValue(), false, tilde);
            sb.append("&").append(name).append("=").append(value);
        }
        return sb.length() == 0 ? "" : sb.substring(1);
    }

    public static String urlEncode(String value, boolean path, boolean tilde) {
        String encoded = null;
        try {
            encoded = URLEncoder.encode(value, "UTF-8");
            encoded = PLUS_PATTERN.matcher(encoded).replaceAll(ENCODE_PLUS_SIGN);
            encoded = ASTERISK_PATTERN.matcher(encoded).replaceAll(ENCODE_ASTERISK_SIGN);
            if (tilde) {
                encoded = TILDE_PATTERN.matcher(encoded).replaceAll(TILDE_SIGN);
            }
            if (path) {
                encoded = SLASH_PATTERN.matcher(encoded).replaceAll(SLASH_SIGN);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new NiftyClientException(e);
        }
        return encoded;
    }

    private String put(String prefix, String name, Object value) {
        return prefix.isEmpty() ? this.put(name, value.toString()) : this.put(prefix + SEPARETOR + name, value.toString());
    }

    private String addPrefix(String prefix, String name) {
        return prefix.isEmpty() ? name : prefix + SEPARETOR + name;
    }

    private String addPostfix(String name, int i) {
        return name + SEPARETOR + i;
    }

    private String ejectSequence(String prefix) {
        int index = prefix.lastIndexOf(SEPARETOR);
        if (index == -1) {
            return "";
        }
        return prefix.substring(index + 1);
    }

    private String exclusionSequence(String prefix) {
        int index = prefix.lastIndexOf(SEPARETOR);
        if (index == -1) {
            return "";
        }
        String parent = prefix.substring(0, index + 1);
        return parent.equals(SEPARETOR) ? "" : parent;
    }

    private boolean useToString(Object obj) {
        return obj instanceof String || obj instanceof Integer || obj instanceof Long || obj instanceof Float || obj instanceof Double || obj instanceof Boolean;
    }
}

