/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.tools;

import com.nifty.cloud.sdk.ClientConfiguration;
import com.nifty.cloud.sdk.ErrorResult;
import com.nifty.cloud.sdk.NiftyClientException;
import com.nifty.cloud.sdk.NiftyServiceException;
import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.Result;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.auth.Credentials;
import com.nifty.cloud.sdk.auth.SignatureUtils;
import com.nifty.cloud.sdk.tools.DateUtils;
import com.nifty.cloud.sdk.tools.HttpClient;
import com.nifty.cloud.sdk.tools.HttpHeaderUtils;
import com.nifty.cloud.sdk.tools.QueryStringGenarator;
import com.nifty.cloud.sdk.tools.XmlUtils;
import com.nifty.cloud.sdk.upload.model.UploadRequest;
import com.nifty.cloud.sdk.upload.model.UploadResult;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;

public class NiftyCloudApiClient {
    private static HttpClient client = null;
    private Credentials credential;
    private ClientConfiguration config;
    private String endpoint = "https://jp-east-1.computing.api.nifcloud.com/api/";
    private String uploadEndpoint = "https://jp-east-1.vmupload.computing.api.nifcloud.com/VmUpload/vmupload";
    private static final int MAX_REQUEST_URL_LENGTH = 1000;
    private ProxyAuthenticator auth;

    public NiftyCloudApiClient(Credentials credential, ClientConfiguration config) {
        this.credential = credential;
        this.config = config;
        if (client == null) {
            client = HttpClient.getInstance(config);
        }
        if (config.getConfigEndpoint() != null && !config.getConfigEndpoint().isEmpty()) {
            this.endpoint = config.getConfigEndpoint();
        }
        if (config.getConfigUploadEndpoint() != null && !config.getConfigUploadEndpoint().isEmpty()) {
            this.uploadEndpoint = config.getConfigUploadEndpoint();
        }
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setUploadEndpoint(String uploadEndpoint) {
        this.uploadEndpoint = uploadEndpoint;
    }

    public Result execute(Request request, Class<? extends Result> clazz) {
        try {
            String userAgent;
            String url = this.getUrl();
            String action = this.getAction(request);
            String timeStamp = this.getTimeStamp();
            QueryStringGenarator queryString = new QueryStringGenarator();
            queryString.parseRequest(request);
            queryString.put("AccessKeyId", this.credential.getAccessKeyId());
            queryString.put("Action", action);
            queryString.put("Timestamp", timeStamp);
            queryString.put("SignatureVersion", this.config.getSignatureVersion().getValue());
            if (this.config.getSignatureVersion() != SignatureUtils.SignatureVersion.Version_0 && this.config.getSignatureVersion() != SignatureUtils.SignatureVersion.Version_1) {
                queryString.put("SignatureMethod", this.config.getSignatureMethod().getAlgorithm());
            }
            String signature = SignatureUtils.caluculateSignature(this.config.getSignatureVersion(), this.config.getSignatureMethod(), this.credential.getSecretKey(), this.config.getRequestMethod(), url, queryString);
            queryString.put("Signature", signature);
            NiftyCloudApiResult niftyCloudApiResult = null;
            try {
                niftyCloudApiResult = this.executeApi(url, queryString);
            }
            catch (IOException e) {
                throw new NiftyServiceException(e);
            }
            Result result = XmlUtils.xml2Bean(niftyCloudApiResult.getResponseXml(), clazz);
            if (result == null) {
                result = clazz.newInstance();
            }
            result.setUserAgent((userAgent = this.config.getUserAgent()).equals("NIFCLOUD API Java SDK") ? userAgent : userAgent);
            result.setUrl(this.endpoint);
            result.setQueryString(queryString.toQueryString());
            result.setRequestHeader(niftyCloudApiResult.getRequestHeader());
            result.setStatus(niftyCloudApiResult.getStatus());
            result.setStatusText(niftyCloudApiResult.getStatusText());
            result.setReseponseHeader(niftyCloudApiResult.getReseponseHeader());
            result.setResponseXml(niftyCloudApiResult.getResponseXml());
            if (this.config.getProxyHost() != null && !this.config.getProxyHost().isEmpty()) {
                if (this.config.getProxyPort() != 0) {
                    result.setProxy(this.config.getProxyHost() + ':' + this.config.getProxyPort());
                } else {
                    result.setProxy(this.config.getProxyHost());
                }
            }
            if (result instanceof ErrorResult) {
                throw new NiftyServiceException(((ErrorResult)result).getFaultMessage());
            }
            return result;
        }
        catch (NiftyClientException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NiftyClientException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NiftyCloudApiResult executeApi(String url, QueryStringGenarator queryString) throws IOException {
        int status;
        HttpPost httpreq = null;
        String statusText = null;
        String requestHeaders = null;
        String responseHeaders = null;
        String responseXml = null;
        String query = queryString.toQueryString();
        try {
            if (!this.config.getRequestMethod().equals("POST")) {
                String requestUrl = url + query;
                if (requestUrl.length() >= 1000) {
                    throw new NiftyClientException("Length of request URL exceeds the limit. Please use POST method instead of GET method.");
                }
                httpreq = new HttpGet(url + "?" + query);
            } else {
                httpreq = new HttpPost(url);
                HttpEntity entity = EntityBuilder.create().setText(query).setContentType(ContentType.APPLICATION_FORM_URLENCODED.withCharset("UTF-8")).build();
                httpreq.setEntity(entity);
            }
            CloseableHttpResponse httpresp = client.execute((HttpUriRequest)httpreq);
            status = httpresp.getStatusLine().getStatusCode();
            statusText = httpresp.getStatusLine().getReasonPhrase();
            requestHeaders = this.getRequestHeaders((HttpRequest)httpreq);
            responseHeaders = this.getResponseHeaders((HttpResponse)httpresp);
            responseXml = this.getResponseBody((HttpResponse)httpresp);
            httpresp.close();
        }
        finally {
            if (httpreq != null) {
                httpreq.releaseConnection();
            }
        }
        return new NiftyCloudApiResult(status, statusText, requestHeaders, responseHeaders, responseXml);
    }

    private String getResponseBody(HttpResponse httpresp) throws IOException {
        int length = 0;
        int offset = 0;
        byte[] tmp = new byte[1024];
        InputStream is = httpresp.getEntity().getContent();
        while ((length = is.read(tmp, offset, tmp.length - offset)) != -1) {
            if (tmp.length != (offset += length)) continue;
            byte[] newTmp = new byte[tmp.length * 2];
            System.arraycopy(tmp, 0, newTmp, 0, tmp.length);
            tmp = newTmp;
        }
        is.close();
        return new String(tmp, 0, offset, "UTF-8");
    }

    public UploadResult processLargeSizeUpload(UploadRequest request, Class<? extends UploadResult> clazz) {
        File file = request.getFile();
        if (file == null) {
            throw new IllegalArgumentException("The upload file cannot be null.");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("The upload file must exists.");
        }
        HttpPost httpreq = new HttpPost(this.getUploadUrl());
        this.fillUploadRequest((HttpRequest)httpreq, request, new HashMap<String, String>(), 0);
        try {
            CloseableHttpResponse httpresp = client.execute((HttpUriRequest)httpreq);
            UploadResult result = this.createUploadResult((HttpRequest)httpreq, (HttpResponse)httpresp, clazz);
            httpresp.close();
            UploadResult uploadResult = result;
            return uploadResult;
        }
        catch (Exception e) {
            throw new NiftyClientException(e);
        }
        finally {
            httpreq.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UploadResult executeLargeSizeUpload(UploadRequest request, Class<? extends UploadResult> clazz) {
        File file = request.getFile();
        if (file == null) {
            throw new IllegalArgumentException("The upload file cannot be null.");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("The upload file must exists.");
        }
        int partSize = request.getPartSize();
        HashMap<String, String> headerMap = new HashMap<String, String>();
        FileChannel fc = null;
        UploadResult result = null;
        try {
            fc = new FileInputStream(request.getFile()).getChannel();
            ByteBuffer bb = null;
            long fileLength = file.length();
            long sent = 0L;
            for (long i = request.getOffset(); i < fileLength; i += (long)request.getPartSize()) {
                if (fileLength - i < (long)partSize) {
                    partSize = (int)(fileLength - i);
                    bb = ByteBuffer.allocate(partSize);
                } else if (bb == null) {
                    bb = ByteBuffer.allocate(partSize);
                }
                bb.rewind();
                fc.read(bb, i);
                HttpPost httpreq = new HttpPost(this.getUploadUrl());
                httpreq.setEntity((HttpEntity)new ByteArrayEntity(bb.array()));
                this.fillUploadRequest((HttpRequest)httpreq, request, headerMap, partSize);
                httpreq.setHeader("content-type", "application/octet-stream");
                try {
                    CloseableHttpResponse httpresp = client.execute((HttpUriRequest)httpreq);
                    result = this.createUploadResult((HttpRequest)httpreq, (HttpResponse)httpresp, clazz);
                    httpresp.close();
                }
                finally {
                    httpreq.releaseConnection();
                }
                request.setPosition(result.getPosition());
                request.notifyProgress(partSize, sent += (long)partSize);
                Thread.sleep(100L);
            }
        }
        catch (Exception e) {
            throw new NiftyClientException(e);
        }
        finally {
            if (fc != null) {
                try {
                    fc.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    private void fillUploadRequest(HttpRequest httpreq, UploadRequest request, Map<String, String> headerMap, int partSize) {
        request.getHeaders(headerMap, partSize);
        for (Map.Entry<String, String> entry : headerMap.entrySet()) {
            httpreq.setHeader(entry.getKey(), entry.getValue());
        }
    }

    private UploadResult createUploadResult(HttpRequest httpreq, HttpResponse httpresp, Class<? extends UploadResult> clazz) throws Exception {
        int status = httpresp.getStatusLine().getStatusCode();
        UploadResult result = clazz.newInstance();
        result.applyResponse(httpresp);
        String errorMessage = result.getErrorMessage();
        if (errorMessage != null) {
            throw new NiftyServiceException(errorMessage);
        }
        String userAgent = this.config.getUserAgent();
        result.setUserAgent(userAgent.equals("NIFCLOUD API Java SDK") ? userAgent : userAgent);
        result.setUrl(this.endpoint);
        result.setRequestHeader(this.getRequestHeaders(httpreq));
        result.setStatus(status);
        result.setStatusText(httpresp.getStatusLine().getReasonPhrase());
        result.setReseponseHeader(this.getResponseHeaders(httpresp));
        Header nextPosition = HttpHeaderUtils.getCondensedHeader(httpresp, "x-nifty-upload-next-position");
        if (nextPosition != null) {
            result.setPosition(Long.valueOf(nextPosition.getValue()));
        }
        if (this.config.getProxyHost() != null && !this.config.getProxyHost().isEmpty()) {
            result.setProxy(this.config.getProxyPort() == 0 ? this.config.getProxyHost() : this.config.getProxyHost() + ':' + this.config.getProxyPort());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHttpText(String url) throws IOException {
        String httpText;
        String proxyHost = this.config.getProxyHost();
        BufferedReader reader = null;
        HttpURLConnection urlCon = null;
        try {
            String line;
            if (this.auth == null && proxyHost != null && this.config.getProxyUsername() != null && this.config.getProxyPassword() != null) {
                this.auth = new ProxyAuthenticator(proxyHost, this.config.getProxyUsername(), this.config.getProxyPassword());
                Authenticator.setDefault(this.auth);
            }
            URL urlObj = new URL(url);
            if (proxyHost == null) {
                urlCon = (HttpURLConnection)urlObj.openConnection();
            } else {
                int proxyPort = this.config.getProxyPort();
                Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
                urlCon = (HttpURLConnection)urlObj.openConnection(proxy);
            }
            reader = new BufferedReader(new InputStreamReader(urlCon.getInputStream(), "UTF-8"));
            StringBuilder buf = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                buf.append(line);
                buf.append('\n');
            }
            httpText = buf.toString();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw new NiftyServiceException(e);
                }
            }
            if (urlCon != null) {
                urlCon.disconnect();
            }
        }
        return httpText;
    }

    private String getUrl() {
        if (this.endpoint.contains("://")) {
            return this.endpoint;
        }
        return this.config.getProtocol().toString() + "://" + this.endpoint;
    }

    private String getUploadUrl() {
        if (this.uploadEndpoint.contains("://")) {
            return this.uploadEndpoint;
        }
        return this.config.getProtocol().toString() + "://" + this.uploadEndpoint;
    }

    public ClientConfiguration getConfig() {
        return this.config;
    }

    private String getAction(Request request) {
        Action action = request.getClass().getAnnotation(Action.class);
        if (action == null) {
            throw new NiftyClientException("Not found action name.");
        }
        return action.value();
    }

    private String getTimeStamp() {
        return DateUtils.toISO8601FormatedString(new Date());
    }

    private String getRequestHeaders(HttpRequest httpreq) {
        return this.concatHeaders(httpreq.getAllHeaders());
    }

    private String getResponseHeaders(HttpResponse httpresp) {
        return this.concatHeaders(httpresp.getAllHeaders());
    }

    private String concatHeaders(Header[] headers) {
        StringBuilder sb = new StringBuilder();
        for (Header header : headers) {
            sb.append(header.getName()).append(": ").append(header.getValue()).append("\n");
        }
        return sb.toString();
    }

    public static class ProxyAuthenticator
    extends Authenticator {
        private URL url;
        private PasswordAuthentication auth;

        public ProxyAuthenticator(String proxyhost, String userid, String password) throws IOException {
            this.url = new URL("http://" + proxyhost);
            this.auth = new PasswordAuthentication(userid, password.toCharArray());
        }

        @Override
        public URL getRequestingURL() {
            return this.url;
        }

        @Override
        protected Authenticator.RequestorType getRequestorType() {
            return Authenticator.RequestorType.PROXY;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return this.auth;
        }
    }

    private class NiftyCloudApiResult
    extends Result {
        public NiftyCloudApiResult(int status, String statusText, String requestHeaders, String reseponseHeader, String responseXml) {
            this.setStatus(status);
            this.setStatusText(statusText);
            this.setRequestHeader(requestHeaders);
            this.setReseponseHeader(reseponseHeader);
            this.setResponseXml(responseXml);
        }
    }
}

