/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.tools;

import com.nifty.cloud.sdk.ClientConfiguration;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;

public class HttpClient {
    private static HttpClient instance = new HttpClient();
    private static String initialize = "";
    private CloseableHttpClient httpclient = null;

    private HttpClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpClient getInstance(ClientConfiguration config) {
        if (initialize.isEmpty()) {
            String string = initialize;
            synchronized (string) {
                HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
                if (config.getProxyHost() != null && !config.getProxyHost().isEmpty()) {
                    HttpHost proxy = config.getProxyPort() != 0 ? new HttpHost(config.getProxyHost(), config.getProxyPort()) : new HttpHost(config.getProxyHost());
                    httpClientBuilder.setProxy(proxy);
                    if (config.getProxyUsername() != null && !config.getProxyUsername().isEmpty() && config.getProxyPassword() != null && !config.getProxyPassword().isEmpty()) {
                        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                        credsProvider.setCredentials(new AuthScope(config.getProxyHost(), config.getProxyPort()), (Credentials)new UsernamePasswordCredentials(config.getProxyUsername(), config.getProxyPassword()));
                        httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
                    }
                }
                httpClientBuilder.setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(config.getMaxErrorRetry(), false){

                    public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                        boolean retry = super.retryRequest(exception, executionCount, context);
                        if (retry) {
                            try {
                                Thread.sleep(300L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        return retry;
                    }
                });
                String userAgent = config.getUserAgent();
                if (userAgent != null && !userAgent.isEmpty()) {
                    httpClientBuilder.setUserAgent(userAgent.equals("NIFCLOUD API Java SDK") ? userAgent : userAgent);
                }
                httpClientBuilder.setMaxConnTotal(config.getMaxConnections());
                RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(config.getConnectionTimeout() * 1000).setSocketTimeout(config.getSocketTimeout() * 1000).build();
                httpClientBuilder.setDefaultRequestConfig(requestConfig);
                int[] bufferSizes = config.getSocketBufferSizeHints();
                SocketConfig.Builder socketConfigBuilder = SocketConfig.custom();
                if (bufferSizes[0] != 0) {
                    socketConfigBuilder.setSndBufSize(bufferSizes[0]);
                }
                if (bufferSizes[1] != 0) {
                    socketConfigBuilder.setRcvBufSize(bufferSizes[1]);
                }
                httpClientBuilder.setDefaultSocketConfig(socketConfigBuilder.build());
                if (config.getSslTrustSelfSigned().booleanValue()) {
                    try {
                        SSLContext sslContext = SSLContexts.custom().loadTrustMaterial((TrustStrategy)new TrustSelfSignedStrategy()).build();
                        httpClientBuilder.setSSLContext(sslContext);
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new RuntimeException(e);
                    }
                    catch (KeyStoreException e) {
                        throw new RuntimeException(e);
                    }
                    catch (KeyManagementException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (!config.getSslVerifyHostname().booleanValue()) {
                    httpClientBuilder.setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                }
                HttpClient.instance.httpclient = httpClientBuilder.build();
                initialize = "initialized";
            }
        }
        return instance;
    }

    public CloseableHttpResponse execute(HttpUriRequest httpreq) throws IOException {
        return this.httpclient.execute(httpreq);
    }
}

