/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.tools;

import com.nifty.cloud.sdk.NiftyClientException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public final class DateUtils {
    public static String toString(Date date) {
        XMLGregorianCalendar calendar = null;
        try {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(date);
            calendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(cal);
        }
        catch (DatatypeConfigurationException e) {
            throw new NiftyClientException(e);
        }
        return calendar.toXMLFormat();
    }

    public static String toISO8601FormatedString(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        return df.format(date);
    }

    public static String toStringWithoutMsec(Date date) {
        XMLGregorianCalendar calendar = null;
        try {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(date);
            calendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(cal);
            calendar.setFractionalSecond(null);
        }
        catch (DatatypeConfigurationException e) {
            throw new NiftyClientException(e);
        }
        return calendar.toXMLFormat();
    }

    public static String toStringYmd(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd");
        return df.format(date);
    }

    public static Date toDate(String timeStamp) {
        XMLGregorianCalendar calendar = null;
        if (timeStamp == null || timeStamp.isEmpty()) {
            return null;
        }
        try {
            calendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(timeStamp);
        }
        catch (IllegalArgumentException e) {
            throw new NiftyClientException(e);
        }
        catch (DatatypeConfigurationException e) {
            throw new NiftyClientException(e);
        }
        return calendar.toGregorianCalendar().getTime();
    }

    public static Date toDateYmd(String timeStamp) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        Date date = null;
        if (timeStamp == null || timeStamp.isEmpty()) {
            return null;
        }
        try {
            date = sdf.parse(timeStamp);
        }
        catch (ParseException e) {
            throw new NiftyClientException(e);
        }
        return date;
    }
}

