/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.server.model.transform;

import com.nifty.cloud.sdk.server.model.DiskImageDescription;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

public class DiskImageDescriptionConverter
implements Converter {
    private static final String ELEMENT_FORMAT = "format";
    private static final String ELEMENT_SIZE = "size";
    private static final String ELEMENT_IMPORT_MANIFEST_URL = "importManifestUrl";
    private static final String ELEMENT_CHECKSUM = "checksum";

    public boolean canConvert(Class clazz) {
        return clazz == DiskImageDescription.class;
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        DiskImageDescription diskImageDescription = new DiskImageDescription();
        String name = null;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            name = reader.getNodeName();
            if (ELEMENT_FORMAT.equals(name)) {
                diskImageDescription.setFormat(reader.getValue());
            } else if (ELEMENT_SIZE.equals(name)) {
                diskImageDescription.setSize(new Long(reader.getValue()));
            } else if (ELEMENT_IMPORT_MANIFEST_URL.equals(name)) {
                diskImageDescription.setImportManifestUrl(reader.getValue());
            } else if (ELEMENT_CHECKSUM.equals(name)) {
                diskImageDescription.setChecksum(new Integer(reader.getValue()));
            }
            reader.moveUp();
        }
        return diskImageDescription;
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
    }
}

