/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.server.model.transform;

import com.nifty.cloud.sdk.server.model.ConversionTask;
import com.nifty.cloud.sdk.server.model.ImportInstance;
import com.nifty.cloud.sdk.server.model.transform.ImportInstanceConverter;
import com.nifty.cloud.sdk.server.model.transform.NetworkInterfaceSetConverter;
import com.nifty.cloud.sdk.server.model.transform.TagSetConverter;
import com.nifty.cloud.sdk.tools.DateUtils;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.List;

public class ConversionTaskConverter
implements Converter {
    private static final String ELEMENT_CONVERSION_TASK_ID = "conversionTaskId";
    private static final String ELEMENT_EXPIRATION_TIME = "expirationTime";
    private static final String ELEMENT_IMPORT_INSTANCE = "importInstance";
    private static final String ELEMENT_STATE = "state";
    private static final String ELEMENT_STATUS_MESSAGE = "statusMessage";
    private static final String ELEMENT_TAG_SET = "tagSet";
    private static final String ELEMENT_NETWORK_INTERFACE = "networkInterfaceSet";

    public boolean canConvert(Class clazz) {
        return clazz == ConversionTask.class;
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        ConversionTask conversionTask = new ConversionTask();
        ImportInstanceConverter importInstanceConverter = new ImportInstanceConverter();
        TagSetConverter tagSetConverter = new TagSetConverter();
        NetworkInterfaceSetConverter networkInterfaceConverter = new NetworkInterfaceSetConverter();
        String name = null;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            name = reader.getNodeName();
            if (ELEMENT_CONVERSION_TASK_ID.equals(name)) {
                conversionTask.setConversionTaskId(reader.getValue());
            } else if (ELEMENT_EXPIRATION_TIME.equals(name)) {
                conversionTask.setExpirationTime(DateUtils.toDate(reader.getValue()));
            } else if (ELEMENT_IMPORT_INSTANCE.equals(name)) {
                conversionTask.setImportInstance((ImportInstance)importInstanceConverter.unmarshal(reader, context));
            } else if (ELEMENT_STATE.equals(name)) {
                conversionTask.setState(reader.getValue());
            } else if (ELEMENT_STATUS_MESSAGE.equals(name)) {
                conversionTask.setStatusMessage(reader.getValue());
            } else if (ELEMENT_TAG_SET.equals(name)) {
                conversionTask.setTagSet((List)tagSetConverter.unmarshal(reader, context));
            } else if (name.equals(ELEMENT_NETWORK_INTERFACE)) {
                conversionTask.setNetworkInterface((List)networkInterfaceConverter.unmarshal(reader, context));
            }
            reader.moveUp();
        }
        return conversionTask;
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
    }
}

