/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.server.model.transform;

import com.nifty.cloud.sdk.server.model.Attachment;
import com.nifty.cloud.sdk.tools.DateUtils;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

public class AttachmentConverter
implements Converter {
    private static final String ELEMENT_ATTACHMENT_ID = "attachmentID";
    private static final String ELEMENT_DEVICE_INDEX = "deviceIndex";
    private static final String ELEMENT_STATUS = "status";
    private static final String ELEMENT_ATTACH_TIME = "attachTime";
    private static final String ELEMENT_DELETE_ON_TERMINATION = "deleteOnTermination";

    public boolean canConvert(Class clazz) {
        return clazz == Attachment.class;
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Attachment attachment = new Attachment();
        String name = null;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            name = reader.getNodeName();
            if (name.equals(ELEMENT_ATTACHMENT_ID)) {
                attachment.setAttachmentId(reader.getValue());
            } else if (name.equals(ELEMENT_DEVICE_INDEX)) {
                attachment.setDeviceIndex(Short.parseShort(reader.getValue()));
            } else if (name.equals(ELEMENT_STATUS)) {
                attachment.setStatus(reader.getValue());
            } else if (name.equals(ELEMENT_ATTACH_TIME)) {
                attachment.setAttachTime(DateUtils.toDate(reader.getValue()));
            } else if (name.equals(ELEMENT_DELETE_ON_TERMINATION)) {
                attachment.setDeleteOnTermination(new Boolean(reader.getValue()));
            }
            reader.moveUp();
        }
        return attachment;
    }

    public void marshal(Object paramObject, HierarchicalStreamWriter paramHierarchicalStreamWriter, MarshallingContext paramMarshallingContext) {
    }
}

