/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.server.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Action(value="TerminateInstances")
public class TerminateInstancesRequest
implements Request {
    private List<String> instanceIds;

    public TerminateInstancesRequest() {
    }

    public TerminateInstancesRequest(List<String> instanceIds) {
        this.instanceIds = instanceIds;
    }

    @Query(name="InstanceId", require=true)
    public List<String> getInstanceIds() {
        return this.instanceIds;
    }

    public void setInstanceIds(List<String> instanceIds) {
        this.instanceIds = instanceIds;
    }

    public TerminateInstancesRequest withInstanceIds(String ... instanceIds) {
        if (this.instanceIds == null) {
            this.instanceIds = new ArrayList<String>();
        }
        for (String instanceId : instanceIds) {
            this.getInstanceIds().add(instanceId);
        }
        return this;
    }

    public TerminateInstancesRequest withInstanceIds(Collection<String> instanceIds) {
        if (this.instanceIds == null) {
            this.instanceIds = new ArrayList<String>();
        }
        if (instanceIds != null) {
            this.getInstanceIds().addAll(instanceIds);
        }
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[instanceIds=");
        builder.append(this.instanceIds);
        builder.append("]");
        return builder.toString();
    }
}

