/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.server.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Action(value="StopInstances")
public class StopInstancesRequest
implements Request {
    private List<String> instanceIds;
    private Boolean force;
    private List<String> tenancies;

    public StopInstancesRequest() {
    }

    public StopInstancesRequest(List<String> instanceIds) {
        this.instanceIds = instanceIds;
    }

    @Query(name="InstanceId", require=true)
    public List<String> getInstanceIds() {
        return this.instanceIds;
    }

    public void setInstanceIds(List<String> instanceIds) {
        this.instanceIds = instanceIds;
    }

    public StopInstancesRequest withInstanceIds(String ... instanceIds) {
        if (this.instanceIds == null) {
            this.instanceIds = new ArrayList<String>();
        }
        for (String instanceId : instanceIds) {
            this.getInstanceIds().add(instanceId);
        }
        return this;
    }

    public StopInstancesRequest withInstanceIds(Collection<String> instanceIds) {
        if (this.instanceIds == null) {
            this.instanceIds = new ArrayList<String>();
        }
        if (instanceIds != null) {
            this.getInstanceIds().addAll(instanceIds);
        }
        return this;
    }

    @Query(name="Force")
    public Boolean getForce() {
        return this.force;
    }

    public void setForce(Boolean force) {
        this.force = force;
    }

    public StopInstancesRequest withForce(Boolean force) {
        this.setForce(force);
        return this;
    }

    @Query(name="Tenancy")
    public List<String> getTenancies() {
        return this.tenancies;
    }

    public void setTenancies(List<String> tenancies) {
        this.tenancies = tenancies;
    }

    public StopInstancesRequest withTenancies(String ... tenancies) {
        if (this.tenancies == null) {
            this.tenancies = new ArrayList<String>();
        }
        for (String tenancy : tenancies) {
            this.getTenancies().add(tenancy);
        }
        return this;
    }

    public StopInstancesRequest withTenancies(Collection<String> tenancies) {
        if (this.tenancies == null) {
            this.tenancies = new ArrayList<String>();
        }
        if (tenancies != null) {
            this.getTenancies().addAll(tenancies);
        }
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[instanceIds=");
        builder.append(this.instanceIds);
        builder.append(", force=");
        builder.append(this.force);
        builder.append(", tenancies=");
        builder.append(this.tenancies);
        builder.append("]");
        return builder.toString();
    }
}

