/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.server.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;
import com.nifty.cloud.sdk.server.model.InstanceIdSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Action(value="StartInstances")
public class StartInstancesRequest
implements Request {
    private List<InstanceIdSet> instances;
    private String userData;
    private String userDataEncoding;
    private Boolean niftyIsBios;
    private List<String> tenancies;

    @Query(name="", alias="InstanceIdSet", require=true)
    public List<InstanceIdSet> getInstances() {
        return this.instances;
    }

    public void setInstances(List<InstanceIdSet> instanceSets) {
        this.instances = instanceSets;
    }

    public StartInstancesRequest withInstances(InstanceIdSet ... instanceSets) {
        if (this.instances == null) {
            this.instances = new ArrayList<InstanceIdSet>();
        }
        for (InstanceIdSet instanceSet : instanceSets) {
            this.getInstances().add(instanceSet);
        }
        return this;
    }

    public StartInstancesRequest withInstances(Collection<InstanceIdSet> instanceSets) {
        if (this.instances == null) {
            this.instances = new ArrayList<InstanceIdSet>();
        }
        if (instanceSets != null) {
            this.getInstances().addAll(instanceSets);
        }
        return this;
    }

    @Query(name="UserData")
    public String getUserData() {
        return this.userData;
    }

    public void setUserData(String userData) {
        this.userData = userData;
    }

    public StartInstancesRequest withUserData(String userData) {
        this.setUserData(userData);
        return this;
    }

    @Query(name="UserData.Encoding")
    public String getUserDataEncoding() {
        return this.userDataEncoding;
    }

    public void setUserDataEncoding(String userDataEncoding) {
        this.userDataEncoding = userDataEncoding;
    }

    public StartInstancesRequest withUserDataEncoding(String userDataEncoding) {
        this.setUserDataEncoding(userDataEncoding);
        return this;
    }

    @Query(name="NiftyIsBios")
    public Boolean getNiftyIsBios() {
        return this.niftyIsBios;
    }

    public void setNiftyIsBios(Boolean niftyIsBios) {
        this.niftyIsBios = niftyIsBios;
    }

    public StartInstancesRequest withNiftyIsBios(Boolean niftyIsBios) {
        this.setNiftyIsBios(niftyIsBios);
        return this;
    }

    @Query(name="Tenancy")
    public List<String> getTenancies() {
        return this.tenancies;
    }

    public void setTenancies(List<String> tenancies) {
        this.tenancies = tenancies;
    }

    public StartInstancesRequest withTenancies(String ... tenancies) {
        if (this.tenancies == null) {
            this.tenancies = new ArrayList<String>();
        }
        for (String tenancy : tenancies) {
            this.getTenancies().add(tenancy);
        }
        return this;
    }

    public StartInstancesRequest withTenancies(Collection<String> tenancies) {
        if (this.tenancies == null) {
            this.tenancies = new ArrayList<String>();
        }
        if (tenancies != null) {
            this.getTenancies().addAll(tenancies);
        }
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[instances=");
        builder.append(this.instances);
        builder.append(", userData=");
        builder.append(this.userData);
        builder.append(", userDataEncoding=");
        builder.append(this.userDataEncoding);
        builder.append(", niftyIsBios=");
        builder.append(this.niftyIsBios);
        builder.append(", tenancies=");
        builder.append(this.tenancies);
        builder.append("]");
        return builder.toString();
    }
}

