/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.server.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;
import com.nifty.cloud.sdk.server.model.BlockDeviceMapping;
import com.nifty.cloud.sdk.server.model.License;
import com.nifty.cloud.sdk.server.model.NetworkInterface;
import com.nifty.cloud.sdk.server.model.Placement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Action(value="RunInstances")
public class RunInstancesRequest
implements Request {
    private String imageId;
    private Integer minCount;
    private Integer maxCount;
    private String keyName;
    private List<String> groupNames;
    private String additionalInfo;
    private String userData;
    private String userDataEncoding;
    private String addressingType;
    private String instanceType;
    private Placement placement;
    private String kernelId;
    private String ramdiskId;
    private List<BlockDeviceMapping> blockDeviceMappings;
    private Boolean monitoring;
    private String subnetId;
    private Boolean disableApiTermination;
    private String instanceInitiatedShutdownBehavior;
    private String accountingType;
    private String instanceId;
    private String admin;
    private String password;
    private String ipType;
    private String publicIp;
    private boolean agreement;
    private String description;
    private List<NetworkInterface> networkInterfaces;
    private List<License> licenses;

    public RunInstancesRequest() {
    }

    public RunInstancesRequest(String imageId) {
        this.imageId = imageId;
    }

    @Query(name="ImageId", require=true)
    public String getImageId() {
        return this.imageId;
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    public RunInstancesRequest withImageId(String imageId) {
        this.setImageId(imageId);
        return this;
    }

    @Query(name="MinCount")
    public Integer getMinCount() {
        return this.minCount;
    }

    public void setMinCount(Integer minCount) {
        this.minCount = minCount;
    }

    public RunInstancesRequest withMinCount(Integer minCount) {
        this.setMinCount(minCount);
        return this;
    }

    @Query(name="MaxCount")
    public Integer getMaxCount() {
        return this.maxCount;
    }

    public void setMaxCount(Integer maxCount) {
        this.maxCount = maxCount;
    }

    public RunInstancesRequest withMaxCount(Integer maxCount) {
        this.setMaxCount(maxCount);
        return this;
    }

    @Query(name="KeyName")
    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public RunInstancesRequest withKeyName(String keyName) {
        this.setKeyName(keyName);
        return this;
    }

    @Query(name="SecurityGroup")
    public List<String> getGroupNames() {
        return this.groupNames;
    }

    public void setGroupNames(List<String> groupNames) {
        this.groupNames = groupNames;
    }

    public RunInstancesRequest withGroupNames(String ... groupNames) {
        if (this.groupNames == null) {
            this.groupNames = new ArrayList<String>();
        }
        for (String groupName : groupNames) {
            this.getGroupNames().add(groupName);
        }
        return this;
    }

    public RunInstancesRequest withGroupNames(Collection<String> groupNames) {
        if (this.groupNames == null) {
            this.groupNames = new ArrayList<String>();
        }
        if (groupNames != null) {
            this.getGroupNames().addAll(groupNames);
        }
        return this;
    }

    @Query(name="AdditionalInfo")
    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setAdditionalInfo(String additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    public RunInstancesRequest withAdditionalInfo(String additionalInfo) {
        this.setAdditionalInfo(additionalInfo);
        return this;
    }

    @Query(name="UserData")
    public String getUserData() {
        return this.userData;
    }

    public void setUserData(String userData) {
        this.userData = userData;
    }

    public RunInstancesRequest withUserData(String userData) {
        this.setUserData(userData);
        return this;
    }

    @Query(name="UserData.Encoding")
    public String getUserDataEncoding() {
        return this.userDataEncoding;
    }

    public void setUserDataEncoding(String userDataEncoding) {
        this.userDataEncoding = userDataEncoding;
    }

    public RunInstancesRequest withUserDataEncoding(String userDataEncoding) {
        this.setUserDataEncoding(userDataEncoding);
        return this;
    }

    @Query(name="AddressingType")
    public String getAddressingType() {
        return this.addressingType;
    }

    public void setAddressingType(String addressingType) {
        this.addressingType = addressingType;
    }

    public RunInstancesRequest withAddressingType(String addressingType) {
        this.setAddressingType(addressingType);
        return this;
    }

    @Query(name="InstanceType")
    public String getInstanceType() {
        return this.instanceType;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public RunInstancesRequest withInstanceType(String instanceType) {
        this.setInstanceType(instanceType);
        return this;
    }

    @Query(name="Placement")
    public Placement getPlacement() {
        return this.placement;
    }

    public void setPlacement(Placement placement) {
        this.placement = placement;
    }

    public RunInstancesRequest withPlacement(Placement placement) {
        this.setPlacement(placement);
        return this;
    }

    @Query(name="KernelId")
    public String getKernelId() {
        return this.kernelId;
    }

    public void setKernelId(String kernelId) {
        this.kernelId = kernelId;
    }

    public RunInstancesRequest withKernelId(String kernelId) {
        this.setKernelId(kernelId);
        return this;
    }

    @Query(name="RamdiskId")
    public String getRamdiskId() {
        return this.ramdiskId;
    }

    public void setRamdiskId(String ramdiskId) {
        this.ramdiskId = ramdiskId;
    }

    public RunInstancesRequest withRamdiskId(String ramdiskId) {
        this.setRamdiskId(ramdiskId);
        return this;
    }

    @Query(name="BlockDeviceMapping")
    public List<BlockDeviceMapping> getBlockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public void setBlockDeviceMappings(List<BlockDeviceMapping> blockDeviceMappings) {
        this.blockDeviceMappings = blockDeviceMappings;
    }

    public RunInstancesRequest withBlockDeviceMappings(BlockDeviceMapping ... blockDeviceMappings) {
        if (this.blockDeviceMappings == null) {
            this.blockDeviceMappings = new ArrayList<BlockDeviceMapping>();
        }
        for (BlockDeviceMapping blockDeviceMapping : blockDeviceMappings) {
            this.getBlockDeviceMappings().add(blockDeviceMapping);
        }
        return this;
    }

    public RunInstancesRequest withBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
        if (this.blockDeviceMappings == null) {
            this.blockDeviceMappings = new ArrayList<BlockDeviceMapping>();
        }
        if (blockDeviceMappings != null) {
            this.getBlockDeviceMappings().addAll(blockDeviceMappings);
        }
        return this;
    }

    @Query(name="Monitoring.Enabled")
    public Boolean getMonitoring() {
        return this.monitoring;
    }

    public void setMonitoring(Boolean monitoring) {
        this.monitoring = monitoring;
    }

    public RunInstancesRequest withMonitoring(Boolean monitoring) {
        this.setMonitoring(monitoring);
        return this;
    }

    @Query(name="SubnetId")
    public String getSubnetId() {
        return this.subnetId;
    }

    public void setSubnetId(String subnetId) {
        this.subnetId = subnetId;
    }

    public RunInstancesRequest withSubnetId(String subnetId) {
        this.setSubnetId(subnetId);
        return this;
    }

    @Query(name="DisableApiTermination")
    public Boolean getDisableApiTermination() {
        return this.disableApiTermination;
    }

    public void setDisableApiTermination(Boolean disableApiTermination) {
        this.disableApiTermination = disableApiTermination;
    }

    public RunInstancesRequest withDisableApiTermination(Boolean disableApiTermination) {
        this.setDisableApiTermination(disableApiTermination);
        return this;
    }

    @Query(name="InstanceInitiatedShutdownBehavior")
    public String getInstanceInitiatedShutdownBehavior() {
        return this.instanceInitiatedShutdownBehavior;
    }

    public void setInstanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
        this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
    }

    public RunInstancesRequest withInstanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
        this.setInstanceInitiatedShutdownBehavior(instanceInitiatedShutdownBehavior);
        return this;
    }

    @Query(name="AccountingType")
    public String getAccountingType() {
        return this.accountingType;
    }

    public void setAccountingType(String accountingType) {
        this.accountingType = accountingType;
    }

    public RunInstancesRequest withAccountingType(String accountingType) {
        this.setAccountingType(accountingType);
        return this;
    }

    @Query(name="InstanceId")
    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public RunInstancesRequest withInstanceId(String instanceId) {
        this.setInstanceId(instanceId);
        return this;
    }

    @Query(name="Admin")
    public String getAdmin() {
        return this.admin;
    }

    public void setAdmin(String admin) {
        this.admin = admin;
    }

    public RunInstancesRequest withAdmin(String admin) {
        this.setAdmin(admin);
        return this;
    }

    @Query(name="Password")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public RunInstancesRequest withPassword(String password) {
        this.setPassword(password);
        return this;
    }

    @Query(name="IpType")
    public String getIpType() {
        return this.ipType;
    }

    public void setIpType(String ipType) {
        this.ipType = ipType;
    }

    public RunInstancesRequest withIpType(String ipType) {
        this.setIpType(ipType);
        return this;
    }

    @Query(name="PublicIp")
    public String getPublicIp() {
        return this.publicIp;
    }

    public void setPublicIp(String publicIp) {
        this.publicIp = publicIp;
    }

    public RunInstancesRequest withPublicIp(String publicIp) {
        this.setPublicIp(publicIp);
        return this;
    }

    @Query(name="Agreement")
    public boolean isAgreement() {
        return this.agreement;
    }

    public void setAgreement(boolean agreement) {
        this.agreement = agreement;
    }

    @Query(name="Description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public RunInstancesRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    @Query(name="NetworkInterface")
    public List<NetworkInterface> getNetworkInterfaces() {
        return this.networkInterfaces;
    }

    public void setNetworkInterfaces(List<NetworkInterface> networkInterfaces) {
        this.networkInterfaces = networkInterfaces;
    }

    public RunInstancesRequest withNetworkInterfaces(NetworkInterface ... networkInterfaces) {
        if (this.networkInterfaces == null) {
            this.networkInterfaces = new ArrayList<NetworkInterface>();
        }
        for (NetworkInterface networkInterface : networkInterfaces) {
            this.getNetworkInterfaces().add(networkInterface);
        }
        return this;
    }

    public RunInstancesRequest withNetworkInterfaces(Collection<NetworkInterface> networkInterfaces) {
        if (this.networkInterfaces == null) {
            this.networkInterfaces = new ArrayList<NetworkInterface>();
        }
        if (networkInterfaces != null) {
            this.getNetworkInterfaces().addAll(networkInterfaces);
        }
        return this;
    }

    @Query(name="License")
    public List<License> getLicenses() {
        return this.licenses;
    }

    public void setLicenses(List<License> licenses) {
        this.licenses = licenses;
    }

    public RunInstancesRequest withLicenses(License ... licenses) {
        if (this.licenses == null) {
            this.licenses = new ArrayList<License>();
        }
        for (License license : licenses) {
            this.getLicenses().add(license);
        }
        return this;
    }

    public RunInstancesRequest withLicenses(Collection<License> licenses) {
        if (this.licenses == null) {
            this.licenses = new ArrayList<License>();
        }
        if (licenses != null) {
            this.getLicenses().addAll(licenses);
        }
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[imageId=");
        builder.append(this.imageId);
        builder.append(", minCount=");
        builder.append(this.minCount);
        builder.append(", maxCount=");
        builder.append(this.maxCount);
        builder.append(", keyName=");
        builder.append(this.keyName);
        builder.append(", groupNames=");
        builder.append(this.groupNames);
        builder.append(", additionalInfo=");
        builder.append(this.additionalInfo);
        builder.append(", userData=");
        builder.append(this.userData);
        builder.append(", userDataEncoding=");
        builder.append(this.userDataEncoding);
        builder.append(", addressingType=");
        builder.append(this.addressingType);
        builder.append(", instanceType=");
        builder.append(this.instanceType);
        builder.append(", placement=");
        builder.append(this.placement);
        builder.append(", kernelId=");
        builder.append(this.kernelId);
        builder.append(", ramdiskId=");
        builder.append(this.ramdiskId);
        builder.append(", blockDeviceMappings=");
        builder.append(this.blockDeviceMappings);
        builder.append(", monitoring=");
        builder.append(this.monitoring);
        builder.append(", subnetId=");
        builder.append(this.subnetId);
        builder.append(", disableApiTermination=");
        builder.append(this.disableApiTermination);
        builder.append(", instanceInitiatedShutdownBehavior=");
        builder.append(this.instanceInitiatedShutdownBehavior);
        builder.append(", accountingType=");
        builder.append(this.accountingType);
        builder.append(", instanceId=");
        builder.append(this.instanceId);
        builder.append(", admin=");
        builder.append(this.admin);
        builder.append(", password=");
        builder.append(this.password);
        builder.append(", ipType=");
        builder.append(this.ipType);
        builder.append(", publicIp=");
        builder.append(this.publicIp);
        builder.append(", agreement=");
        builder.append(this.agreement);
        builder.append(", description=");
        builder.append(this.description);
        builder.append(", networkInterface=");
        builder.append(this.networkInterfaces);
        builder.append(", licenses=");
        builder.append(this.licenses);
        builder.append("]");
        return builder.toString();
    }
}

