/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.server.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Action(value="RebootInstances")
public class RebootInstancesRequest
implements Request {
    private List<String> instanceIds;
    private Boolean force;
    private String userData;
    private String userDataEncoding;
    private Boolean niftyIsBios;
    private List<String> tenancies;

    public RebootInstancesRequest() {
    }

    public RebootInstancesRequest(List<String> instanceIds) {
        this.instanceIds = instanceIds;
    }

    @Query(name="InstanceId", require=true)
    public List<String> getInstanceIds() {
        return this.instanceIds;
    }

    public void setInstanceIds(List<String> instanceIds) {
        this.instanceIds = instanceIds;
    }

    public RebootInstancesRequest withInstanceIds(String ... instanceIds) {
        if (this.instanceIds == null) {
            this.instanceIds = new ArrayList<String>();
        }
        for (String instanceId : instanceIds) {
            this.getInstanceIds().add(instanceId);
        }
        return this;
    }

    public RebootInstancesRequest withInstanceIds(Collection<String> instanceIds) {
        if (this.instanceIds == null) {
            this.instanceIds = new ArrayList<String>();
        }
        if (instanceIds != null) {
            this.getInstanceIds().addAll(instanceIds);
        }
        return this;
    }

    @Query(name="Force")
    public Boolean getForce() {
        return this.force;
    }

    public void setForce(Boolean force) {
        this.force = force;
    }

    public RebootInstancesRequest withForce(Boolean force) {
        this.setForce(force);
        return this;
    }

    @Query(name="UserData")
    public String getUserData() {
        return this.userData;
    }

    public void setUserData(String userData) {
        this.userData = userData;
    }

    public RebootInstancesRequest withUserData(String userData) {
        this.setUserData(userData);
        return this;
    }

    @Query(name="UserData.Encoding")
    public String getUserDataEncoding() {
        return this.userDataEncoding;
    }

    public void setUserDataEncoding(String userDataEncoding) {
        this.userDataEncoding = userDataEncoding;
    }

    public RebootInstancesRequest withUserDataEncoding(String userDataEncoding) {
        this.setUserDataEncoding(userDataEncoding);
        return this;
    }

    @Query(name="NiftyIsBios")
    public Boolean getNiftyIsBios() {
        return this.niftyIsBios;
    }

    public void setNiftyIsBios(Boolean niftyIsBios) {
        this.niftyIsBios = niftyIsBios;
    }

    public RebootInstancesRequest withNiftyIsBios(Boolean niftyIsBios) {
        this.setNiftyIsBios(niftyIsBios);
        return this;
    }

    @Query(name="Tenancy")
    public List<String> getTenancies() {
        return this.tenancies;
    }

    public void setTenancies(List<String> tenancies) {
        this.tenancies = tenancies;
    }

    public RebootInstancesRequest withTenancies(String ... tenancies) {
        if (this.tenancies == null) {
            this.tenancies = new ArrayList<String>();
        }
        for (String tenancy : tenancies) {
            this.getTenancies().add(tenancy);
        }
        return this;
    }

    public RebootInstancesRequest withTenancies(Collection<String> tenancies) {
        if (this.tenancies == null) {
            this.tenancies = new ArrayList<String>();
        }
        if (tenancies != null) {
            this.getTenancies().addAll(tenancies);
        }
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[instanceIds=");
        builder.append(this.instanceIds);
        builder.append(", force=");
        builder.append(this.force);
        builder.append(", userData=");
        builder.append(this.userData);
        builder.append(", userDataEncoding=");
        builder.append(this.userDataEncoding);
        builder.append(", niftyIsBios=");
        builder.append(this.niftyIsBios);
        builder.append(", tenancies=");
        builder.append(this.tenancies);
        builder.append("]");
        return builder.toString();
    }
}

