/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.server.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;
import com.nifty.cloud.sdk.server.model.InstanceBlockDeviceMappingSpecification;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Action(value="ModifyInstanceAttribute")
public class ModifyInstanceAttributeRequest
implements Request {
    private String instanceId;
    private String attribute;
    private String value;
    private List<InstanceBlockDeviceMappingSpecification> blockDeviceMappings;
    private String niftyReboot;
    private Boolean force;
    private String tenancy;

    public ModifyInstanceAttributeRequest() {
    }

    public ModifyInstanceAttributeRequest(String instanceId) {
        this.instanceId = instanceId;
    }

    @Query(name="InstanceId", require=true)
    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public ModifyInstanceAttributeRequest withInstanceId(String instanceId) {
        this.setInstanceId(instanceId);
        return this;
    }

    @Query(name="Attribute")
    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public ModifyInstanceAttributeRequest withAttribute(String attribute) {
        this.setAttribute(attribute);
        return this;
    }

    @Query(name="Value")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public ModifyInstanceAttributeRequest withValue(String value) {
        this.setValue(value);
        return this;
    }

    @Query(name="")
    public List<InstanceBlockDeviceMappingSpecification> getBlockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public void setBlockDeviceMappings(List<InstanceBlockDeviceMappingSpecification> blockDeviceMappings) {
        this.blockDeviceMappings = blockDeviceMappings;
    }

    public ModifyInstanceAttributeRequest withBlockDeviceMappings(InstanceBlockDeviceMappingSpecification ... blockDeviceMappings) {
        if (this.blockDeviceMappings == null) {
            this.blockDeviceMappings = new ArrayList<InstanceBlockDeviceMappingSpecification>();
        }
        for (InstanceBlockDeviceMappingSpecification blockDeviceMapping : blockDeviceMappings) {
            this.getBlockDeviceMappings().add(blockDeviceMapping);
        }
        return this;
    }

    public ModifyInstanceAttributeRequest withBlockDeviceMappings(Collection<InstanceBlockDeviceMappingSpecification> blockDeviceMappings) {
        if (this.blockDeviceMappings == null) {
            this.blockDeviceMappings = new ArrayList<InstanceBlockDeviceMappingSpecification>();
        }
        if (blockDeviceMappings != null) {
            this.getBlockDeviceMappings().addAll(blockDeviceMappings);
        }
        return this;
    }

    @Query(name="NiftyReboot")
    public String getNiftyReboot() {
        return this.niftyReboot;
    }

    public void setNiftyReboot(String niftyReboot) {
        this.niftyReboot = niftyReboot;
    }

    public ModifyInstanceAttributeRequest withNiftyReboot(String niftyReboot) {
        this.setNiftyReboot(niftyReboot);
        return this;
    }

    @Query(name="Force")
    public Boolean getForce() {
        return this.force;
    }

    public void setForce(Boolean force) {
        this.force = force;
    }

    public ModifyInstanceAttributeRequest withForce(Boolean force) {
        this.setForce(force);
        return this;
    }

    @Query(name="Tenancy")
    public String getTenancy() {
        return this.tenancy;
    }

    public void setTenancy(String tenancy) {
        this.tenancy = tenancy;
    }

    public ModifyInstanceAttributeRequest withTenancy(String tenancy) {
        this.setTenancy(tenancy);
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[instanceId=");
        builder.append(this.instanceId);
        builder.append(", attribute=");
        builder.append(this.attribute);
        builder.append(", value=");
        builder.append(this.value);
        builder.append(", blockDeviceMappings=");
        builder.append(this.blockDeviceMappings);
        builder.append(", niftyReboot=");
        builder.append(this.niftyReboot);
        builder.append(", force=");
        builder.append(this.force);
        builder.append(", tenancy=");
        builder.append(this.tenancy);
        builder.append("]");
        return builder.toString();
    }
}

