/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.server.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;
import com.nifty.cloud.sdk.server.model.DiskImage;
import com.nifty.cloud.sdk.server.model.InstancePlacement;
import com.nifty.cloud.sdk.server.model.NetworkInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Action(value="ImportInstance")
public class ImportInstanceRequest
implements Request {
    private String description;
    private String architecture;
    private List<String> groupIds;
    private String userData;
    private String instanceType;
    private InstancePlacement placement;
    private Boolean monitoring;
    private String subnetId;
    private String instanceInitiatedShutdownBehavior;
    private String privateIpAddress;
    private String accountingType;
    private String ipType;
    private String publicIp;
    private List<DiskImage> diskImageSet;
    private String instanceId;
    private String ovf;
    private Boolean keepPartialImports;
    private String platform;
    private List<NetworkInterface> networkInterfaces;

    public ImportInstanceRequest() {
    }

    public ImportInstanceRequest(String ovf) {
        this.ovf = ovf;
    }

    @Query(name="Description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ImportInstanceRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    @Query(name="Architecture")
    public String getArchitecture() {
        return this.architecture;
    }

    public void setArchitecture(String architecture) {
        this.architecture = architecture;
    }

    public ImportInstanceRequest withArchitecture(String architecture) {
        this.setArchitecture(architecture);
        return this;
    }

    @Query(name="SecurityGroup")
    public List<String> getGroupIds() {
        return this.groupIds;
    }

    public void setGroupIds(List<String> groupIds) {
        this.groupIds = groupIds;
    }

    public ImportInstanceRequest withGroupIds(Collection<String> groupIds) {
        if (this.groupIds == null) {
            this.groupIds = new ArrayList<String>();
        }
        if (groupIds != null) {
            this.groupIds.addAll(groupIds);
        }
        return this;
    }

    public ImportInstanceRequest withGroupIds(String ... groupIds) {
        if (this.groupIds == null) {
            this.groupIds = new ArrayList<String>();
        }
        for (String item : groupIds) {
            this.groupIds.add(item);
        }
        return this;
    }

    @Query(name="UserData")
    public String getUserData() {
        return this.userData;
    }

    public void setUserData(String userData) {
        this.userData = userData;
    }

    public ImportInstanceRequest withUserData(String userData) {
        this.setUserData(userData);
        return this;
    }

    @Query(name="InstanceType")
    public String getInstanceType() {
        return this.instanceType;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public ImportInstanceRequest withInstanceType(String instanceType) {
        this.setInstanceType(instanceType);
        return this;
    }

    @Query(name="Placement")
    public InstancePlacement getPlacement() {
        return this.placement;
    }

    public void setPlacement(InstancePlacement placement) {
        this.placement = placement;
    }

    public ImportInstanceRequest withPlacement(InstancePlacement placement) {
        this.setPlacement(placement);
        return this;
    }

    @Query(name="Monitoring.Enabled")
    public Boolean getMonitoring() {
        return this.monitoring;
    }

    public void setMonitoring(Boolean monitoring) {
        this.monitoring = monitoring;
    }

    public ImportInstanceRequest withMonitoring(Boolean monitoring) {
        this.setMonitoring(monitoring);
        return this;
    }

    @Query(name="SubnetId")
    public String getSubnetId() {
        return this.subnetId;
    }

    public void setSubnetId(String subnetId) {
        this.subnetId = subnetId;
    }

    public ImportInstanceRequest withSubnetId(String subnetId) {
        this.setSubnetId(subnetId);
        return this;
    }

    @Query(name="InstanceInitiatedShutdownBehavior")
    public String getInstanceInitiatedShutdownBehavior() {
        return this.instanceInitiatedShutdownBehavior;
    }

    public void setInstanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
        this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
    }

    public ImportInstanceRequest withInstanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
        this.setInstanceInitiatedShutdownBehavior(instanceInitiatedShutdownBehavior);
        return this;
    }

    @Query(name="PrivateIpAddress")
    public String getPrivateIpAddress() {
        return this.privateIpAddress;
    }

    public void setPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
    }

    public ImportInstanceRequest withPrivateIpAddress(String privateIpAddress) {
        this.setPrivateIpAddress(privateIpAddress);
        return this;
    }

    @Query(name="AccountingType")
    public String getAccountingType() {
        return this.accountingType;
    }

    public void setAccountingType(String accountingType) {
        this.accountingType = accountingType;
    }

    public ImportInstanceRequest withAccountingType(String accountingType) {
        this.setAccountingType(accountingType);
        return this;
    }

    @Query(name="IpType")
    public String getIpType() {
        return this.ipType;
    }

    public void setIpType(String ipType) {
        this.ipType = ipType;
    }

    public ImportInstanceRequest withIpType(String ipType) {
        this.setIpType(ipType);
        return this;
    }

    @Query(name="PublicIp")
    public String getPublicIp() {
        return this.publicIp;
    }

    public void setPublicIp(String publicIp) {
        this.publicIp = publicIp;
    }

    public ImportInstanceRequest withPublicIp(String publicIp) {
        this.setPublicIp(publicIp);
        return this;
    }

    @Query(name="DiskImage")
    public List<DiskImage> getDiskImageSet() {
        return this.diskImageSet;
    }

    public void setDiskImageSet(List<DiskImage> diskImageSet) {
        this.diskImageSet = diskImageSet;
    }

    public ImportInstanceRequest withDiskImageSet(Collection<DiskImage> diskImageSet) {
        if (this.diskImageSet == null) {
            this.diskImageSet = new ArrayList<DiskImage>();
        }
        if (diskImageSet != null) {
            this.diskImageSet.addAll(diskImageSet);
        }
        return this;
    }

    public ImportInstanceRequest withDiskImageSet(DiskImage ... diskImageSet) {
        if (this.diskImageSet == null) {
            this.diskImageSet = new ArrayList<DiskImage>();
        }
        for (DiskImage item : diskImageSet) {
            this.diskImageSet.add(item);
        }
        return this;
    }

    @Query(name="InstanceId")
    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public ImportInstanceRequest withInstanceId(String instanceId) {
        this.setInstanceId(instanceId);
        return this;
    }

    @Query(name="Ovf", require=true)
    public String getOvf() {
        return this.ovf;
    }

    public void setOvf(String ovf) {
        this.ovf = ovf;
    }

    public ImportInstanceRequest withOvf(String ovf) {
        this.setOvf(ovf);
        return this;
    }

    @Query(name="KeepPartialImports")
    public Boolean getKeepPartialImports() {
        return this.keepPartialImports;
    }

    public void setKeepPartialImports(Boolean keepPartialImports) {
        this.keepPartialImports = keepPartialImports;
    }

    public ImportInstanceRequest withKeepPartialImports(Boolean keepPartialImports) {
        this.setKeepPartialImports(keepPartialImports);
        return this;
    }

    @Query(name="Platform")
    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public ImportInstanceRequest withPlatform(String platform) {
        this.setPlatform(platform);
        return this;
    }

    @Query(name="NetworkInterface")
    public List<NetworkInterface> getNetworkInterfaces() {
        return this.networkInterfaces;
    }

    public void setNetworkInterfaces(List<NetworkInterface> networkInterfaces) {
        this.networkInterfaces = networkInterfaces;
    }

    public ImportInstanceRequest withNetworkInterfaces(NetworkInterface ... networkInterfaces) {
        if (this.networkInterfaces == null) {
            this.networkInterfaces = new ArrayList<NetworkInterface>();
        }
        for (NetworkInterface networkInterface : networkInterfaces) {
            this.getNetworkInterfaces().add(networkInterface);
        }
        return this;
    }

    public ImportInstanceRequest withNetworkInterfaces(Collection<NetworkInterface> networkInterfaces) {
        if (this.networkInterfaces == null) {
            this.networkInterfaces = new ArrayList<NetworkInterface>();
        }
        if (networkInterfaces != null) {
            this.getNetworkInterfaces().addAll(networkInterfaces);
        }
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[description=");
        builder.append(this.description);
        builder.append(", architecture=");
        builder.append(this.architecture);
        builder.append(", groupIds=");
        builder.append(this.groupIds);
        builder.append(", userData=");
        builder.append(this.userData);
        builder.append(", instanceType=");
        builder.append(this.instanceType);
        builder.append(", placement=");
        builder.append(this.placement);
        builder.append(", monitoring=");
        builder.append(this.monitoring);
        builder.append(", subnetId=");
        builder.append(this.subnetId);
        builder.append(", instanceInitiatedShutdownBehavior=");
        builder.append(this.instanceInitiatedShutdownBehavior);
        builder.append(", privateIpAddress=");
        builder.append(this.privateIpAddress);
        builder.append(", accountingType=");
        builder.append(this.accountingType);
        builder.append(", ipType=");
        builder.append(this.ipType);
        builder.append(", publicIp=");
        builder.append(this.publicIp);
        builder.append(", diskImageSet=");
        builder.append(this.diskImageSet);
        builder.append(", instanceId=");
        builder.append(this.instanceId);
        builder.append(", ovf=");
        builder.append(this.ovf);
        builder.append(", keepPartialImports=");
        builder.append(this.keepPartialImports);
        builder.append(", platform=");
        builder.append(this.platform);
        builder.append(", networkInterface=");
        builder.append(this.networkInterfaces);
        builder.append("]");
        return builder.toString();
    }
}

