/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.server.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;
import com.nifty.cloud.sdk.server.model.CopyInstance;
import com.nifty.cloud.sdk.server.model.NetworkInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Action(value="CopyInstances")
public class CopyInstancesRequest
implements Request {
    private String instanceId;
    private CopyInstance copyInstance;
    private Integer copyCount;
    private List<NetworkInterface> networkInterfaces;

    public CopyInstancesRequest() {
    }

    public CopyInstancesRequest(String instanceId) {
        this.instanceId = instanceId;
    }

    @Query(name="InstanceId", require=true)
    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public CopyInstancesRequest withInstanceId(String instanceId) {
        this.setInstanceId(instanceId);
        return this;
    }

    @Query(name="CopyInstance", require=true)
    public CopyInstance getCopyInstance() {
        return this.copyInstance;
    }

    public void setCopyInstance(CopyInstance copyInstance) {
        this.copyInstance = copyInstance;
    }

    public CopyInstancesRequest withCopyInstance(CopyInstance copyInstance) {
        this.setCopyInstance(copyInstance);
        return this;
    }

    @Query(name="CopyCount")
    public Integer getCopyCount() {
        return this.copyCount;
    }

    public void setCopyCount(Integer copyCount) {
        this.copyCount = copyCount;
    }

    public CopyInstancesRequest withCopyCount(Integer copyCount) {
        this.setCopyCount(copyCount);
        return this;
    }

    @Query(name="NetworkInterface")
    public List<NetworkInterface> getNetworkInterfaces() {
        return this.networkInterfaces;
    }

    public void setNetworkInterfaces(List<NetworkInterface> networkInterfaces) {
        this.networkInterfaces = networkInterfaces;
    }

    public CopyInstancesRequest withNetworkInterfaces(NetworkInterface ... networkInterfaces) {
        if (this.networkInterfaces == null) {
            this.networkInterfaces = new ArrayList<NetworkInterface>();
        }
        for (NetworkInterface networkInterface : networkInterfaces) {
            this.getNetworkInterfaces().add(networkInterface);
        }
        return this;
    }

    public CopyInstancesRequest withNetworkInterfaces(Collection<NetworkInterface> networkInterfaces) {
        if (this.networkInterfaces == null) {
            this.networkInterfaces = new ArrayList<NetworkInterface>();
        }
        if (networkInterfaces != null) {
            this.getNetworkInterfaces().addAll(networkInterfaces);
        }
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[instanceId=");
        builder.append(this.instanceId);
        builder.append(", copyInstance=");
        builder.append(this.copyInstance);
        builder.append(", copyCount=");
        builder.append(this.copyCount);
        builder.append(", networkInterface=");
        builder.append(this.networkInterfaces);
        builder.append("]");
        return builder.toString();
    }
}

