/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.security;

import com.nifty.cloud.sdk.ClientConfiguration;
import com.nifty.cloud.sdk.auth.Credentials;
import com.nifty.cloud.sdk.security.NiftySecurityAsync;
import com.nifty.cloud.sdk.security.NiftySecurityClient;
import com.nifty.cloud.sdk.security.model.CreateKeyPairRequest;
import com.nifty.cloud.sdk.security.model.CreateKeyPairResult;
import com.nifty.cloud.sdk.security.model.DeleteKeyPairRequest;
import com.nifty.cloud.sdk.security.model.DeleteKeyPairResult;
import com.nifty.cloud.sdk.security.model.DescribeKeyPairsRequest;
import com.nifty.cloud.sdk.security.model.DescribeKeyPairsResult;
import com.nifty.cloud.sdk.security.model.ImportKeyPairRequest;
import com.nifty.cloud.sdk.security.model.ImportKeyPairResult;
import com.nifty.cloud.sdk.security.model.NiftyModifyKeyPairAttributeRequest;
import com.nifty.cloud.sdk.security.model.NiftyModifyKeyPairAttributeResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class NiftySecurityAsyncClient
extends NiftySecurityClient
implements NiftySecurityAsync {
    protected ExecutorService executorService = null;

    public NiftySecurityAsyncClient(Credentials credential) {
        this(credential, Executors.newCachedThreadPool());
    }

    public NiftySecurityAsyncClient(Credentials credential, ClientConfiguration configuration) {
        this(credential, configuration, Executors.newCachedThreadPool());
    }

    public NiftySecurityAsyncClient(Credentials credential, ExecutorService executorService) {
        super(credential);
        this.executorService = executorService;
    }

    public NiftySecurityAsyncClient(Credentials credential, ClientConfiguration configuration, ExecutorService executorService) {
        super(credential, configuration);
        this.executorService = executorService;
    }

    @Override
    public Future<CreateKeyPairResult> createKeyPairAsync(final CreateKeyPairRequest request) {
        return this.executorService.submit(new Callable<CreateKeyPairResult>(){

            @Override
            public CreateKeyPairResult call() {
                return NiftySecurityAsyncClient.this.createKeyPair(request);
            }
        });
    }

    @Override
    public Future<DeleteKeyPairResult> deleteKeyPairAsync(final DeleteKeyPairRequest request) {
        return this.executorService.submit(new Callable<DeleteKeyPairResult>(){

            @Override
            public DeleteKeyPairResult call() {
                return NiftySecurityAsyncClient.this.deleteKeyPair(request);
            }
        });
    }

    @Override
    public Future<DescribeKeyPairsResult> describeKeyPairsAsync(final DescribeKeyPairsRequest request) {
        return this.executorService.submit(new Callable<DescribeKeyPairsResult>(){

            @Override
            public DescribeKeyPairsResult call() {
                return NiftySecurityAsyncClient.this.describeKeyPairs(request);
            }
        });
    }

    @Override
    public Future<NiftyModifyKeyPairAttributeResult> niftyModifyKeyPairAttributeAsync(final NiftyModifyKeyPairAttributeRequest request) {
        return this.executorService.submit(new Callable<NiftyModifyKeyPairAttributeResult>(){

            @Override
            public NiftyModifyKeyPairAttributeResult call() {
                return NiftySecurityAsyncClient.this.niftyModifyKeyPairAttribute(request);
            }
        });
    }

    @Override
    public Future<ImportKeyPairResult> importKeyPairAsync(final ImportKeyPairRequest request) {
        return this.executorService.submit(new Callable<ImportKeyPairResult>(){

            @Override
            public ImportKeyPairResult call() {
                return NiftySecurityAsyncClient.this.importKeyPair(request);
            }
        });
    }
}

