/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.router.model.transform;

import com.nifty.cloud.sdk.router.model.BackupInformation;
import com.nifty.cloud.sdk.router.model.Router;
import com.nifty.cloud.sdk.router.model.VersionInformation;
import com.nifty.cloud.sdk.router.model.transform.BackupInformationConverter;
import com.nifty.cloud.sdk.router.model.transform.GroupSetConverter;
import com.nifty.cloud.sdk.router.model.transform.NetworkInterfaceSetConverter;
import com.nifty.cloud.sdk.router.model.transform.TagSetConverter;
import com.nifty.cloud.sdk.router.model.transform.VersionInformationConverter;
import com.nifty.cloud.sdk.tools.DateUtils;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.ArrayList;
import java.util.List;

public class RouterSetConverter
implements Converter {
    private static final String ELEMENT_ROUTER_ID = "routerId";
    private static final String ELEMENT_ROUTER_NAME = "routerName";
    private static final String ELEMENT_STATE = "state";
    private static final String ELEMENT_AVAILABILITY_ZONE = "availabilityZone";
    private static final String ELEMENT_TAG_SET = "tagSet";
    private static final String ELEMENT_ACCOUNTING_TYPE = "accountingType";
    private static final String ELEMENT_NEXT_MONTH_ACCOUNTING_TYPE = "nextMonthAccountingType";
    private static final String ELEMENT_DESCRIPTION = "description";
    private static final String ELEMENT_VERSION_INFORMATION = "versionInformation";
    private static final String ELEMENT_NETWORK_INTERFACE_SET = "networkInterfaceSet";
    private static final String ELEMENT_ROUTE_TABLE_ID = "routeTableId";
    private static final String ELEMENT_ROUTE_TABLE_ASSOCIATION_ID = "routeTableAssociationId";
    private static final String ELEMENT_NAT_TABLE_ID = "natTableId";
    private static final String ELEMENT_NAT_TABLE_ASSOCIATION_ID = "natTableAssociationId";
    private static final String ELEMENT_BACKUP_INFORMATION = "backupInformation";
    private static final String ELEMENT_TYPE = "type";
    private static final String ELEMENT_GROUP_SET = "groupSet";
    private static final String ELEMENT_CREATED_TIME = "createdTime";

    public boolean canConvert(Class clazz) {
        Class<?>[] interfaces;
        for (Class<?> i : interfaces = clazz.getInterfaces()) {
            if (i != List.class) continue;
            return true;
        }
        return false;
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        ArrayList<Router> routers = new ArrayList<Router>();
        TagSetConverter tagSetConverter = new TagSetConverter();
        VersionInformationConverter versionInformationConverter = new VersionInformationConverter();
        NetworkInterfaceSetConverter networkInterfaceSetConverter = new NetworkInterfaceSetConverter();
        BackupInformationConverter backupInformationConverter = new BackupInformationConverter();
        GroupSetConverter groupSetConverter = new GroupSetConverter();
        String name = null;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            Router router = new Router();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                name = reader.getNodeName();
                if (name.equals(ELEMENT_ROUTER_ID)) {
                    router.setRouterId(reader.getValue());
                } else if (name.equals(ELEMENT_ROUTER_NAME)) {
                    router.setRouterName(reader.getValue());
                } else if (name.equals(ELEMENT_STATE)) {
                    router.setState(reader.getValue());
                } else if (name.equals(ELEMENT_AVAILABILITY_ZONE)) {
                    router.setAvailabilityZone(reader.getValue());
                } else if (name.equals(ELEMENT_TAG_SET)) {
                    router.setTagSet((List)tagSetConverter.unmarshal(reader, context));
                } else if (name.equals(ELEMENT_ACCOUNTING_TYPE)) {
                    router.setAccountingType(reader.getValue());
                } else if (name.equals(ELEMENT_NEXT_MONTH_ACCOUNTING_TYPE)) {
                    router.setNextMonthAccountingType(reader.getValue());
                } else if (name.equals(ELEMENT_DESCRIPTION)) {
                    router.setDescription(reader.getValue());
                } else if (name.equals(ELEMENT_VERSION_INFORMATION)) {
                    router.setVersionInformation((VersionInformation)versionInformationConverter.unmarshal(reader, context));
                } else if (name.equals(ELEMENT_NETWORK_INTERFACE_SET)) {
                    router.setNetworkInterfaces((List)networkInterfaceSetConverter.unmarshal(reader, context));
                } else if (name.equals(ELEMENT_ROUTE_TABLE_ID)) {
                    router.setRouteTableId(reader.getValue());
                } else if (name.equals(ELEMENT_ROUTE_TABLE_ASSOCIATION_ID)) {
                    router.setRouteTableAssociationId(reader.getValue());
                } else if (name.equals(ELEMENT_NAT_TABLE_ID)) {
                    router.setNatTableId(reader.getValue());
                } else if (name.equals(ELEMENT_NAT_TABLE_ASSOCIATION_ID)) {
                    router.setNatTableAssociationId(reader.getValue());
                } else if (name.equals(ELEMENT_BACKUP_INFORMATION)) {
                    router.setBackupInformation((BackupInformation)backupInformationConverter.unmarshal(reader, context));
                } else if (name.equals(ELEMENT_TYPE)) {
                    router.setType(reader.getValue());
                } else if (name.equals(ELEMENT_GROUP_SET)) {
                    router.setGroupIds((List)groupSetConverter.unmarshal(reader, context));
                } else if (name.equals(ELEMENT_CREATED_TIME)) {
                    router.setCreatedTime(DateUtils.toDate(reader.getValue()));
                }
                reader.moveUp();
            }
            routers.add(router);
            reader.moveUp();
        }
        return routers;
    }

    public void marshal(Object paramObject, HierarchicalStreamWriter paramHierarchicalStreamWriter, MarshallingContext paramMarshallingContext) {
    }
}

