/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.router.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;
import com.nifty.cloud.sdk.router.model.NetworkInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Action(value="NiftyUpdateRouterNetworkInterfaces")
public class NiftyUpdateRouterNetworkInterfacesRequest
implements Request {
    private String routerId;
    private String routerName;
    private List<NetworkInterface> networkInterfaces;
    private String niftyReboot;
    private Boolean agreement;

    public NiftyUpdateRouterNetworkInterfacesRequest() {
    }

    public NiftyUpdateRouterNetworkInterfacesRequest(List<NetworkInterface> networkInterfaces) {
        this.networkInterfaces = networkInterfaces;
    }

    @Query(name="RouterId")
    public String getRouterId() {
        return this.routerId;
    }

    public void setRouterId(String routerId) {
        this.routerId = routerId;
    }

    public NiftyUpdateRouterNetworkInterfacesRequest withRouterId(String routerId) {
        this.setRouterId(routerId);
        return this;
    }

    @Query(name="RouterName")
    public String getRouterName() {
        return this.routerName;
    }

    public void setRouterName(String routerName) {
        this.routerName = routerName;
    }

    public NiftyUpdateRouterNetworkInterfacesRequest withRouterName(String routerName) {
        this.setRouterName(routerName);
        return this;
    }

    @Query(name="NetworkInterface", require=true)
    public List<NetworkInterface> getNetworkInterfaces() {
        return this.networkInterfaces;
    }

    public void setNetworkInterfaces(List<NetworkInterface> networkInterfaces) {
        this.networkInterfaces = networkInterfaces;
    }

    public NiftyUpdateRouterNetworkInterfacesRequest withNetworkInterfaces(NetworkInterface ... networkInterfaces) {
        if (this.networkInterfaces == null) {
            this.networkInterfaces = new ArrayList<NetworkInterface>();
        }
        for (NetworkInterface networkInterface : networkInterfaces) {
            this.getNetworkInterfaces().add(networkInterface);
        }
        return this;
    }

    public NiftyUpdateRouterNetworkInterfacesRequest withNetworkInterfaces(Collection<NetworkInterface> networkInterfaces) {
        if (this.networkInterfaces == null) {
            this.networkInterfaces = new ArrayList<NetworkInterface>();
        }
        if (networkInterfaces != null) {
            this.getNetworkInterfaces().addAll(networkInterfaces);
        }
        return this;
    }

    @Query(name="NiftyReboot")
    public String getNiftyReboot() {
        return this.niftyReboot;
    }

    public void setNiftyReboot(String niftyReboot) {
        this.niftyReboot = niftyReboot;
    }

    public NiftyUpdateRouterNetworkInterfacesRequest withNiftyReboot(String niftyReboot) {
        this.setNiftyReboot(niftyReboot);
        return this;
    }

    @Query(name="Agreement")
    public Boolean getAgreement() {
        return this.agreement;
    }

    public void setAgreement(Boolean agreement) {
        this.agreement = agreement;
    }

    public NiftyUpdateRouterNetworkInterfacesRequest withAgreement(Boolean agreement) {
        this.setAgreement(agreement);
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[routerId=");
        builder.append(this.routerId);
        builder.append(", routerName=");
        builder.append(this.routerName);
        builder.append(", networkInterfaces=");
        builder.append(this.networkInterfaces);
        builder.append(", niftyReboot=");
        builder.append(this.niftyReboot);
        builder.append(", agreement=");
        builder.append(this.agreement);
        builder.append("]");
        return builder.toString();
    }
}

