/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.router.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;
import com.nifty.cloud.sdk.router.model.NetworkInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Action(value="NiftyCreateRouter")
public class NiftyCreateRouterRequest
implements Request {
    private String routerName;
    private String availabilityZone;
    private String accountingType;
    private String description;
    private String type;
    private List<NetworkInterface> networkInterfaces;
    private List<String> groupIds;

    public NiftyCreateRouterRequest() {
    }

    public NiftyCreateRouterRequest(List<NetworkInterface> networkInterfaces) {
        this.networkInterfaces = networkInterfaces;
    }

    @Query(name="RouterName")
    public String getRouterName() {
        return this.routerName;
    }

    public void setRouterName(String routerName) {
        this.routerName = routerName;
    }

    public NiftyCreateRouterRequest withRouterName(String routerName) {
        this.setRouterName(routerName);
        return this;
    }

    @Query(name="AvailabilityZone")
    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public NiftyCreateRouterRequest withAvailabilityZone(String availabilityZone) {
        this.setAvailabilityZone(availabilityZone);
        return this;
    }

    @Query(name="AccountingType")
    public String getAccountingType() {
        return this.accountingType;
    }

    public void setAccountingType(String accountingType) {
        this.accountingType = accountingType;
    }

    public NiftyCreateRouterRequest withAccountingType(String accountingType) {
        this.setAccountingType(accountingType);
        return this;
    }

    @Query(name="Description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public NiftyCreateRouterRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    @Query(name="Type")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public NiftyCreateRouterRequest withType(String type) {
        this.setType(type);
        return this;
    }

    @Query(name="NetworkInterface", require=true)
    public List<NetworkInterface> getNetworkInterfaces() {
        return this.networkInterfaces;
    }

    public void setNetworkInterfaces(List<NetworkInterface> networkInterfaces) {
        this.networkInterfaces = networkInterfaces;
    }

    public NiftyCreateRouterRequest withNetworkInterfaces(NetworkInterface ... networkInterfaces) {
        if (this.networkInterfaces == null) {
            this.networkInterfaces = new ArrayList<NetworkInterface>();
        }
        for (NetworkInterface networkInterface : networkInterfaces) {
            this.getNetworkInterfaces().add(networkInterface);
        }
        return this;
    }

    public NiftyCreateRouterRequest withNetworkInterfaces(Collection<NetworkInterface> networkInterfaces) {
        if (this.networkInterfaces == null) {
            this.networkInterfaces = new ArrayList<NetworkInterface>();
        }
        if (networkInterfaces != null) {
            this.getNetworkInterfaces().addAll(networkInterfaces);
        }
        return this;
    }

    @Query(name="SecurityGroup")
    public List<String> getGroupIds() {
        return this.groupIds;
    }

    public void setGroupIds(List<String> groupIds) {
        this.groupIds = groupIds;
    }

    public NiftyCreateRouterRequest withGroupIds(String ... groupIds) {
        if (this.groupIds == null) {
            this.groupIds = new ArrayList<String>();
        }
        for (String groupId : groupIds) {
            this.getGroupIds().add(groupId);
        }
        return this;
    }

    public NiftyCreateRouterRequest withGroupIds(Collection<String> groupIds) {
        if (this.groupIds == null) {
            this.groupIds = new ArrayList<String>();
        }
        if (groupIds != null) {
            this.getGroupIds().addAll(groupIds);
        }
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[routerName=");
        builder.append(this.routerName);
        builder.append(", availabilityZone=");
        builder.append(this.availabilityZone);
        builder.append(", accountingType=");
        builder.append(this.accountingType);
        builder.append(", description=");
        builder.append(this.description);
        builder.append(", type=");
        builder.append(this.type);
        builder.append(", networkInterfaces=");
        builder.append(this.networkInterfaces);
        builder.append(", groupIds=");
        builder.append(this.groupIds);
        builder.append("]");
        return builder.toString();
    }
}

