/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.proxy.model.transform;

import com.nifty.cloud.sdk.proxy.model.NetworkInterface;
import com.nifty.cloud.sdk.proxy.model.WebProxy;
import com.nifty.cloud.sdk.proxy.model.WebProxyOption;
import com.nifty.cloud.sdk.proxy.model.transform.NetworkInterfaceConverter;
import com.nifty.cloud.sdk.proxy.model.transform.OptionConverter;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.ArrayList;
import java.util.List;

public class WebProxySetConverter
implements Converter {
    private static final String ELEMENT_ROUTER_ID = "routerId";
    private static final String ELEMENT_ROUTER_NAME = "routerName";
    private static final String ELEMENT_LISTEN_INTERFACE = "listenInterface";
    private static final String ELEMENT_LISTEN_PORT = "listenPort";
    private static final String ELEMENT_BYPASS_INTERFACE = "bypassInterface";
    private static final String ELEMENT_OPTION = "option";
    private static final String ELEMENT_DESCRIPTION = "description";

    public boolean canConvert(Class clazz) {
        Class<?>[] interfaces;
        for (Class<?> i : interfaces = clazz.getInterfaces()) {
            if (i != List.class) continue;
            return true;
        }
        return false;
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        ArrayList<WebProxy> webProxies = new ArrayList<WebProxy>();
        NetworkInterfaceConverter networkInterfaceConverter = new NetworkInterfaceConverter();
        OptionConverter optionConverter = new OptionConverter();
        String name = null;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            WebProxy webProxy = new WebProxy();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                name = reader.getNodeName();
                if (name.equals(ELEMENT_ROUTER_ID)) {
                    webProxy.setRouterId(reader.getValue());
                } else if (name.equals(ELEMENT_ROUTER_NAME)) {
                    webProxy.setRouterName(reader.getValue());
                } else if (name.equals(ELEMENT_LISTEN_INTERFACE)) {
                    webProxy.setListenInterface((NetworkInterface)networkInterfaceConverter.unmarshal(reader, context));
                } else if (name.equals(ELEMENT_LISTEN_PORT)) {
                    webProxy.setListenPort(reader.getValue());
                } else if (name.equals(ELEMENT_BYPASS_INTERFACE)) {
                    webProxy.setBypassInterface((NetworkInterface)networkInterfaceConverter.unmarshal(reader, context));
                } else if (name.equals(ELEMENT_OPTION)) {
                    webProxy.setOption((WebProxyOption)optionConverter.unmarshal(reader, context));
                } else if (name.equals(ELEMENT_DESCRIPTION)) {
                    webProxy.setDescription(reader.getValue());
                }
                reader.moveUp();
            }
            webProxies.add(webProxy);
            reader.moveUp();
        }
        return webProxies;
    }

    public void marshal(Object paramObject, HierarchicalStreamWriter paramHierarchicalStreamWriter, MarshallingContext paramMarshallingContext) {
    }
}

