/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.nic;

import com.nifty.cloud.sdk.ClientConfiguration;
import com.nifty.cloud.sdk.auth.Credentials;
import com.nifty.cloud.sdk.nic.NiftyNicAsync;
import com.nifty.cloud.sdk.nic.NiftyNicClient;
import com.nifty.cloud.sdk.nic.model.AttachNetworkInterfaceRequest;
import com.nifty.cloud.sdk.nic.model.AttachNetworkInterfaceResult;
import com.nifty.cloud.sdk.nic.model.CreateNetworkInterfaceRequest;
import com.nifty.cloud.sdk.nic.model.CreateNetworkInterfaceResult;
import com.nifty.cloud.sdk.nic.model.DeleteNetworkInterfaceRequest;
import com.nifty.cloud.sdk.nic.model.DeleteNetworkInterfaceResult;
import com.nifty.cloud.sdk.nic.model.DescribeNetworkInterfacesRequest;
import com.nifty.cloud.sdk.nic.model.DescribeNetworkInterfacesResult;
import com.nifty.cloud.sdk.nic.model.DetachNetworkInterfaceRequest;
import com.nifty.cloud.sdk.nic.model.DetachNetworkInterfaceResult;
import com.nifty.cloud.sdk.nic.model.ModifyNetworkInterfaceAttributeRequest;
import com.nifty.cloud.sdk.nic.model.ModifyNetworkInterfaceAttributeResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class NiftyNicAsyncClient
extends NiftyNicClient
implements NiftyNicAsync {
    protected ExecutorService executorService = null;

    public NiftyNicAsyncClient(Credentials credential) {
        this(credential, Executors.newCachedThreadPool());
    }

    public NiftyNicAsyncClient(Credentials credential, ClientConfiguration configuration) {
        this(credential, configuration, Executors.newCachedThreadPool());
    }

    public NiftyNicAsyncClient(Credentials credential, ClientConfiguration configuration, ExecutorService executorService) {
        super(credential, configuration);
        this.executorService = executorService;
    }

    public NiftyNicAsyncClient(Credentials credential, ExecutorService executorService) {
        super(credential);
        this.executorService = executorService;
    }

    @Override
    public Future<CreateNetworkInterfaceResult> createNetworkInterfaceAsync(final CreateNetworkInterfaceRequest request) {
        return this.executorService.submit(new Callable<CreateNetworkInterfaceResult>(){

            @Override
            public CreateNetworkInterfaceResult call() {
                return NiftyNicAsyncClient.this.createNetworkInterface(request);
            }
        });
    }

    @Override
    public Future<DescribeNetworkInterfacesResult> describeNetworkInterfacesAsync(final DescribeNetworkInterfacesRequest request) {
        return this.executorService.submit(new Callable<DescribeNetworkInterfacesResult>(){

            @Override
            public DescribeNetworkInterfacesResult call() {
                return NiftyNicAsyncClient.this.describeNetworkInterfaces(request);
            }
        });
    }

    @Override
    public Future<AttachNetworkInterfaceResult> attachNetworkInterfaceAsync(final AttachNetworkInterfaceRequest request) {
        return this.executorService.submit(new Callable<AttachNetworkInterfaceResult>(){

            @Override
            public AttachNetworkInterfaceResult call() {
                return NiftyNicAsyncClient.this.attachNetworkInterface(request);
            }
        });
    }

    @Override
    public Future<DetachNetworkInterfaceResult> detachNetworkInterfaceAsync(final DetachNetworkInterfaceRequest request) {
        return this.executorService.submit(new Callable<DetachNetworkInterfaceResult>(){

            @Override
            public DetachNetworkInterfaceResult call() {
                return NiftyNicAsyncClient.this.detachNetworkInterface(request);
            }
        });
    }

    @Override
    public Future<DeleteNetworkInterfaceResult> deleteNetworkInterfaceAsync(final DeleteNetworkInterfaceRequest request) {
        return this.executorService.submit(new Callable<DeleteNetworkInterfaceResult>(){

            @Override
            public DeleteNetworkInterfaceResult call() {
                return NiftyNicAsyncClient.this.deleteNetworkInterface(request);
            }
        });
    }

    @Override
    public Future<ModifyNetworkInterfaceAttributeResult> modifyNetworkInterfaceAttributeAsync(final ModifyNetworkInterfaceAttributeRequest request) {
        return this.executorService.submit(new Callable<ModifyNetworkInterfaceAttributeResult>(){

            @Override
            public ModifyNetworkInterfaceAttributeResult call() {
                return NiftyNicAsyncClient.this.modifyNetworkInterfaceAttribute(request);
            }
        });
    }
}

