/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.nattable.model.transform;

import com.nifty.cloud.sdk.nattable.model.Destination;
import com.nifty.cloud.sdk.nattable.model.NatRule;
import com.nifty.cloud.sdk.nattable.model.NetworkInterface;
import com.nifty.cloud.sdk.nattable.model.Source;
import com.nifty.cloud.sdk.nattable.model.Translation;
import com.nifty.cloud.sdk.nattable.model.transform.DestinationConverter;
import com.nifty.cloud.sdk.nattable.model.transform.NetworkInterfaceConverter;
import com.nifty.cloud.sdk.nattable.model.transform.SourceConverter;
import com.nifty.cloud.sdk.nattable.model.transform.TranslationConverter;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.ArrayList;
import java.util.List;

public class NatRuleSetConverter
implements Converter {
    private static final String ELEMENT_NAT_TYPE = "natType";
    private static final String ELEMENT_RULE_NUMBER = "ruleNumber";
    private static final String ELEMENT_DESCRIPTION = "description";
    private static final String ELEMENT_PROTOCOL = "protocol";
    private static final String ELEMENT_OUTBOUND_INTERFACE = "outboundInterface";
    private static final String ELEMENT_INBOUND_INTERFACE = "inboundInterface";
    private static final String ELEMENT_DESTINATION = "destination";
    private static final String ELEMENT_SOURCE = "source";
    private static final String ELEMENT_TRANSLATION = "translation";

    public boolean canConvert(Class clazz) {
        Class<?>[] interfaces;
        for (Class<?> i : interfaces = clazz.getInterfaces()) {
            if (i != List.class) continue;
            return true;
        }
        return false;
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        ArrayList<NatRule> natRules = new ArrayList<NatRule>();
        NetworkInterfaceConverter networkInterfaceConverter = new NetworkInterfaceConverter();
        DestinationConverter destinationConverter = new DestinationConverter();
        SourceConverter sourceConverter = new SourceConverter();
        TranslationConverter translationConverter = new TranslationConverter();
        String name = null;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            NatRule natRule = new NatRule();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                name = reader.getNodeName();
                if (name.equals(ELEMENT_NAT_TYPE)) {
                    natRule.setNatType(reader.getValue());
                } else if (name.equals(ELEMENT_RULE_NUMBER)) {
                    natRule.setRuleNumber(reader.getValue());
                } else if (name.equals(ELEMENT_DESCRIPTION)) {
                    natRule.setDescription(reader.getValue());
                } else if (name.equals(ELEMENT_PROTOCOL)) {
                    natRule.setProtocol(reader.getValue());
                } else if (name.equals(ELEMENT_OUTBOUND_INTERFACE)) {
                    natRule.setOutboundInterface((NetworkInterface)networkInterfaceConverter.unmarshal(reader, context));
                } else if (name.equals(ELEMENT_INBOUND_INTERFACE)) {
                    natRule.setInboundInterface((NetworkInterface)networkInterfaceConverter.unmarshal(reader, context));
                } else if (name.equals(ELEMENT_DESTINATION)) {
                    natRule.setDestination((Destination)destinationConverter.unmarshal(reader, context));
                } else if (name.equals(ELEMENT_SOURCE)) {
                    natRule.setSource((Source)sourceConverter.unmarshal(reader, context));
                } else if (name.equals(ELEMENT_TRANSLATION)) {
                    natRule.setTranslation((Translation)translationConverter.unmarshal(reader, context));
                }
                reader.moveUp();
            }
            reader.moveUp();
            natRules.add(natRule);
        }
        return natRules;
    }

    public void marshal(Object paramObject, HierarchicalStreamWriter paramHierarchicalStreamWriter, MarshallingContext paramMarshallingContext) {
    }
}

