/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.multiloadbalancer.model.transform;

import com.nifty.cloud.sdk.multiloadbalancer.model.DescriptionMember;
import com.nifty.cloud.sdk.multiloadbalancer.model.ListenerDescribe;
import com.nifty.cloud.sdk.multiloadbalancer.model.NetworkInterface;
import com.nifty.cloud.sdk.multiloadbalancer.model.SystemIpAddress;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.ArrayList;
import java.util.List;

public class NetworkInterfacesConverter
implements Converter {
    private static final String ELEMENT_NETWORK_INTERFACES = "NetworkInterfaces";
    private static final String ELEMENT_MEMBER = "member";
    private static final String ELEMENT_NETWORK_ID = "NetworkId";
    private static final String ELEMENT_NETWORK_NAME = "NetworkName";
    private static final String ELEMENT_DEVICE_INDEX = "DeviceIndex";
    private static final String ELEMENT_IP_ADDRESS = "IpAddress";
    private static final String ELEMENT_IS_VIP_NETWORK = "IsVipNetwork";
    private static final String ELEMENT_DESCRIPTION = "Description";
    private static final String ELEMENT_SYSTEM_IP_ADDRESSES = "SystemIpAddresses";
    private static final String ELEMENT_SYSTEM_IP_ADDRESS = "SystemIpAddress";

    public boolean canConvert(Class type) {
        Class<?>[] interfaces;
        for (Class<?> i : interfaces = type.getInterfaces()) {
            if (i != List.class) continue;
            return true;
        }
        return false;
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        ArrayList<NetworkInterface> networkList = new ArrayList<NetworkInterface>();
        NetworkInterface network = null;
        String name = null;
        name = reader.getNodeName();
        if (name.equals(ELEMENT_NETWORK_INTERFACES)) {
            while (reader.hasMoreChildren()) {
                DescriptionMember member = new DescriptionMember();
                ListenerDescribe listener = new ListenerDescribe();
                member.setListenerDescribe(listener);
                reader.moveDown();
                name = reader.getNodeName();
                if (name.equals(ELEMENT_MEMBER)) {
                    network = new NetworkInterface();
                    while (reader.hasMoreChildren()) {
                        reader.moveDown();
                        name = reader.getNodeName();
                        if (name.equals(ELEMENT_NETWORK_ID)) {
                            network.setNetworkId(reader.getValue());
                        } else if (name.equals(ELEMENT_NETWORK_NAME)) {
                            network.setNetworkName(reader.getValue());
                        } else if (name.equals(ELEMENT_DEVICE_INDEX)) {
                            network.setDeviceIndex(Integer.parseInt(reader.getValue()));
                        } else if (name.equals(ELEMENT_IP_ADDRESS)) {
                            network.setIpAddress(reader.getValue());
                        } else if (name.equals(ELEMENT_IS_VIP_NETWORK)) {
                            network.setIsVipNetwork(Boolean.parseBoolean(reader.getValue()));
                        } else if (name.equals(ELEMENT_DESCRIPTION)) {
                            network.setDescription(reader.getValue());
                        } else if (name.equals(ELEMENT_SYSTEM_IP_ADDRESSES)) {
                            while (reader.hasMoreChildren()) {
                                reader.moveDown();
                                name = reader.getNodeName();
                                if (name.equals(ELEMENT_MEMBER)) {
                                    while (reader.hasMoreChildren()) {
                                        reader.moveDown();
                                        name = reader.getNodeName();
                                        if (name.equals(ELEMENT_SYSTEM_IP_ADDRESS)) {
                                            SystemIpAddress systemIpAddress = new SystemIpAddress();
                                            network.withSystemIpAddresses(systemIpAddress.withSystemIpAddress(reader.getValue()));
                                        }
                                        reader.moveUp();
                                    }
                                }
                                reader.moveUp();
                            }
                        }
                        reader.moveUp();
                    }
                    networkList.add(network);
                }
                reader.moveUp();
            }
        }
        return networkList;
    }
}

