/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.multiloadbalancer.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;
import com.nifty.cloud.sdk.multiloadbalancer.model.AvailabilityZones;
import com.nifty.cloud.sdk.multiloadbalancer.model.NetworkInterface;
import com.nifty.cloud.sdk.multiloadbalancer.model.RequestListenerCreate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Action(value="NiftyCreateElasticLoadBalancer")
public class NiftyCreateElasticLoadBalancerRequest
implements Request {
    private String elasticLoadBalancerName;
    private RequestListenerCreate requestListenerCreate;
    private AvailabilityZones availabilityZones;
    private Integer networkVolume;
    private String accountingType;
    private List<NetworkInterface> networkInterfaceList;

    @Query(name="ElasticLoadBalancerName")
    public String getElasticLoadBalancerName() {
        return this.elasticLoadBalancerName;
    }

    public void setElasticLoadBalancerName(String elasticLoadBalancerName) {
        this.elasticLoadBalancerName = elasticLoadBalancerName;
    }

    public NiftyCreateElasticLoadBalancerRequest withElasticLoadBalancerName(String elasticLoadBalancerName) {
        this.setElasticLoadBalancerName(elasticLoadBalancerName);
        return this;
    }

    @Query(name="Listeners")
    public RequestListenerCreate getRequestListenerCreate() {
        return this.requestListenerCreate;
    }

    public void setRequestListenerCreate(RequestListenerCreate requestListenerCreate) {
        this.requestListenerCreate = requestListenerCreate;
    }

    public NiftyCreateElasticLoadBalancerRequest withRequestListenerCreate(RequestListenerCreate requestListenerCreate) {
        this.setRequestListenerCreate(requestListenerCreate);
        return this;
    }

    @Query(name="AvailabilityZones")
    public AvailabilityZones getAvailabilityZones() {
        return this.availabilityZones;
    }

    public void setAvailabilityZones(AvailabilityZones availabilityZones) {
        this.availabilityZones = availabilityZones;
    }

    public NiftyCreateElasticLoadBalancerRequest withAvailabilityZones(AvailabilityZones availabilityZones) {
        this.setAvailabilityZones(availabilityZones);
        return this;
    }

    @Query(name="NetworkVolume")
    public Integer getNetworkVolume() {
        return this.networkVolume;
    }

    public void setNetworkVolume(Integer networkVolume) {
        this.networkVolume = networkVolume;
    }

    public NiftyCreateElasticLoadBalancerRequest withNetworkVolume(Integer networkVolume) {
        this.setNetworkVolume(networkVolume);
        return this;
    }

    @Query(name="AccountingType")
    public String getAccountingType() {
        return this.accountingType;
    }

    public void setAccountingType(String accountingType) {
        this.accountingType = accountingType;
    }

    public NiftyCreateElasticLoadBalancerRequest withAccountingType(String accountingType) {
        this.setAccountingType(accountingType);
        return this;
    }

    @Query(name="NetworkInterface")
    public List<NetworkInterface> getNetworkInterfaceList() {
        return this.networkInterfaceList;
    }

    public void setNetworkInterfaceList(List<NetworkInterface> networkInterfaceList) {
        this.networkInterfaceList = networkInterfaceList;
    }

    public NiftyCreateElasticLoadBalancerRequest withNetworkInterfaceList(Collection<NetworkInterface> networkInterfaceList) {
        if (this.networkInterfaceList == null) {
            this.networkInterfaceList = new ArrayList<NetworkInterface>();
        }
        if (networkInterfaceList != null && !networkInterfaceList.isEmpty()) {
            this.getNetworkInterfaceList().addAll(networkInterfaceList);
        }
        return this;
    }

    public NiftyCreateElasticLoadBalancerRequest withNetworkInterfaceList(NetworkInterface ... networkInterface) {
        if (this.networkInterfaceList == null) {
            this.networkInterfaceList = new ArrayList<NetworkInterface>();
        }
        if (networkInterface != null && networkInterface.length > 0) {
            for (NetworkInterface work : networkInterface) {
                this.getNetworkInterfaceList().add(work);
            }
        }
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[elasticLoadBalancerName=");
        builder.append(this.elasticLoadBalancerName);
        builder.append(", requestListenerCreate=");
        builder.append(this.requestListenerCreate);
        builder.append(", availabilityZones=");
        builder.append(this.availabilityZones);
        builder.append(", networkVolume=");
        builder.append(this.networkVolume);
        builder.append(", accountingType=");
        builder.append(this.accountingType);
        builder.append(", networkInterfaceList=");
        builder.append(this.networkInterfaceList);
        builder.append("]");
        return builder.toString();
    }
}

