/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.misc;

import com.nifty.cloud.sdk.ClientConfiguration;
import com.nifty.cloud.sdk.auth.Credentials;
import com.nifty.cloud.sdk.misc.NiftyMiscAsync;
import com.nifty.cloud.sdk.misc.NiftyMiscClient;
import com.nifty.cloud.sdk.misc.model.AssociateUsersRequest;
import com.nifty.cloud.sdk.misc.model.AssociateUsersResult;
import com.nifty.cloud.sdk.misc.model.DescribeAssociatedUsersRequest;
import com.nifty.cloud.sdk.misc.model.DescribeAssociatedUsersResult;
import com.nifty.cloud.sdk.misc.model.DescribeAvailabilityZonesRequest;
import com.nifty.cloud.sdk.misc.model.DescribeAvailabilityZonesResult;
import com.nifty.cloud.sdk.misc.model.DescribeRegionsRequest;
import com.nifty.cloud.sdk.misc.model.DescribeRegionsResult;
import com.nifty.cloud.sdk.misc.model.DissociateUsersRequest;
import com.nifty.cloud.sdk.misc.model.DissociateUsersResult;
import com.nifty.cloud.sdk.misc.model.NiftyDescribePerformanceChartRequest;
import com.nifty.cloud.sdk.misc.model.NiftyDescribePerformanceChartResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class NiftyMiscAsyncClient
extends NiftyMiscClient
implements NiftyMiscAsync {
    protected ExecutorService executorService = null;

    public NiftyMiscAsyncClient(Credentials credential) {
        this(credential, Executors.newCachedThreadPool());
    }

    public NiftyMiscAsyncClient(Credentials credential, ClientConfiguration configuration) {
        this(credential, configuration, Executors.newCachedThreadPool());
    }

    public NiftyMiscAsyncClient(Credentials credential, ExecutorService executorService) {
        super(credential);
        this.executorService = executorService;
    }

    public NiftyMiscAsyncClient(Credentials credential, ClientConfiguration configuration, ExecutorService executorService) {
        super(credential, configuration);
        this.executorService = executorService;
    }

    @Override
    public Future<DescribeAvailabilityZonesResult> describeAvailabilityZonesAsync(final DescribeAvailabilityZonesRequest request) {
        return this.executorService.submit(new Callable<DescribeAvailabilityZonesResult>(){

            @Override
            public DescribeAvailabilityZonesResult call() {
                return NiftyMiscAsyncClient.this.describeAvailabilityZones(request);
            }
        });
    }

    @Override
    public Future<DescribeRegionsResult> describeRegionsAsync(final DescribeRegionsRequest request) {
        return this.executorService.submit(new Callable<DescribeRegionsResult>(){

            @Override
            public DescribeRegionsResult call() {
                return NiftyMiscAsyncClient.this.describeRegions(request);
            }
        });
    }

    @Override
    public Future<AssociateUsersResult> associateUsersAsync(final AssociateUsersRequest request) {
        return this.executorService.submit(new Callable<AssociateUsersResult>(){

            @Override
            public AssociateUsersResult call() {
                return NiftyMiscAsyncClient.this.associateUsers(request);
            }
        });
    }

    @Override
    public Future<DissociateUsersResult> dissociateUsersAsync(final DissociateUsersRequest request) {
        return this.executorService.submit(new Callable<DissociateUsersResult>(){

            @Override
            public DissociateUsersResult call() {
                return NiftyMiscAsyncClient.this.dissociateUsers(request);
            }
        });
    }

    @Override
    public Future<DescribeAssociatedUsersResult> describeAssociatedUsersAsync(final DescribeAssociatedUsersRequest request) {
        return this.executorService.submit(new Callable<DescribeAssociatedUsersResult>(){

            @Override
            public DescribeAssociatedUsersResult call() {
                return NiftyMiscAsyncClient.this.describeAssociatedUsers(request);
            }
        });
    }

    @Override
    public Future<NiftyDescribePerformanceChartResult> niftyDescribePerformanceChartAsync(final NiftyDescribePerformanceChartRequest request) {
        return this.executorService.submit(new Callable<NiftyDescribePerformanceChartResult>(){

            @Override
            public NiftyDescribePerformanceChartResult call() {
                return NiftyMiscAsyncClient.this.niftyDescribePerformanceChart(request);
            }
        });
    }
}

