/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.loadbalancer.model.transform;

import com.nifty.cloud.sdk.loadbalancer.model.Filter;
import com.nifty.cloud.sdk.loadbalancer.model.HealthCheck;
import com.nifty.cloud.sdk.loadbalancer.model.LoadBalancerDescription;
import com.nifty.cloud.sdk.loadbalancer.model.LoadBalancerOption;
import com.nifty.cloud.sdk.loadbalancer.model.Policies;
import com.nifty.cloud.sdk.loadbalancer.model.transform.AvailabilityZonesConverter;
import com.nifty.cloud.sdk.loadbalancer.model.transform.FilterConverter;
import com.nifty.cloud.sdk.loadbalancer.model.transform.HealthCheckConverter;
import com.nifty.cloud.sdk.loadbalancer.model.transform.InstancesConverter;
import com.nifty.cloud.sdk.loadbalancer.model.transform.ListenerDescriptionsConverter;
import com.nifty.cloud.sdk.loadbalancer.model.transform.LoadBalancerOptionConverter;
import com.nifty.cloud.sdk.loadbalancer.model.transform.PoliciesConverter;
import com.nifty.cloud.sdk.tools.DateUtils;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.ArrayList;
import java.util.List;

public class LoadBalancerDescriptionsConverter
implements Converter {
    private static final String ELEMENT_LOAD_BALANCER_NAME = "LoadBalancerName";
    private static final String ELEMENT_DNS_NAME = "DNSName";
    private static final String ELEMENT_NETWORK_VOLUME = "NetworkVolume";
    private static final String ELEMENT_POLICY_TYPE = "PolicyType";
    private static final String ELEMENT_LISTNER_DESCRIPTIONS = "ListenerDescriptions";
    private static final String ELEMENT_POLICIES = "Policies";
    private static final String ELEMENT_AVAILABILITY_ZONES = "AvailabilityZones";
    private static final String ELEMENT_INSTANCES = "Instances";
    private static final String ELEMENT_HEALTH_CHECK = "HealthCheck";
    private static final String ELEMENT_FILETR = "Filter";
    private static final String ELEMENT_CREATED_TIME = "CreatedTime";
    private static final String ELEMENT_ACCOUNTING_TYPE = "AccountingType";
    private static final String ELEMENT_NEXT_MONTH_ACCOUNTING_TYPE = "NextMonthAccountingType";
    private static final String ELEMENT_OPTION = "Option";

    public boolean canConvert(Class clazz) {
        Class<?>[] interfaces;
        for (Class<?> i : interfaces = clazz.getInterfaces()) {
            if (i != List.class) continue;
            return true;
        }
        return false;
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        ArrayList<LoadBalancerDescription> loadBalancerDescriptions = new ArrayList<LoadBalancerDescription>();
        ListenerDescriptionsConverter listenerDescriptionsConverter = new ListenerDescriptionsConverter();
        PoliciesConverter policiesConverter = new PoliciesConverter();
        AvailabilityZonesConverter availabilityZonesConverter = new AvailabilityZonesConverter();
        InstancesConverter instancesConverter = new InstancesConverter();
        HealthCheckConverter healthCheckConverter = new HealthCheckConverter();
        FilterConverter filterConverter = new FilterConverter();
        LoadBalancerOptionConverter optionConverter = new LoadBalancerOptionConverter();
        String name = null;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            LoadBalancerDescription loadBalancerDescription = new LoadBalancerDescription();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                name = reader.getNodeName();
                if (name.equals(ELEMENT_LOAD_BALANCER_NAME)) {
                    loadBalancerDescription.setLoadBalancerName(reader.getValue());
                } else if (name.equals(ELEMENT_DNS_NAME)) {
                    loadBalancerDescription.setDNSName(reader.getValue());
                } else if (name.equals(ELEMENT_NETWORK_VOLUME)) {
                    loadBalancerDescription.setNetworkVolume(new Integer(reader.getValue()));
                } else if (name.equals(ELEMENT_POLICY_TYPE)) {
                    loadBalancerDescription.setPolicyType(reader.getValue());
                } else if (name.equals(ELEMENT_LISTNER_DESCRIPTIONS)) {
                    loadBalancerDescription.setListenerDescriptions((List)listenerDescriptionsConverter.unmarshal(reader, context));
                } else if (name.equals(ELEMENT_POLICIES)) {
                    loadBalancerDescription.setPolicies((Policies)policiesConverter.unmarshal(reader, context));
                } else if (name.equals(ELEMENT_AVAILABILITY_ZONES)) {
                    loadBalancerDescription.setAvailabilityZones((List)availabilityZonesConverter.unmarshal(reader, context));
                } else if (name.equals(ELEMENT_INSTANCES)) {
                    loadBalancerDescription.setInstances((List)instancesConverter.unmarshal(reader, context));
                } else if (name.equals(ELEMENT_HEALTH_CHECK)) {
                    loadBalancerDescription.setHealthCheck((HealthCheck)healthCheckConverter.unmarshal(reader, context));
                } else if (name.equals(ELEMENT_FILETR)) {
                    loadBalancerDescription.setFilter((Filter)filterConverter.unmarshal(reader, context));
                } else if (name.equals(ELEMENT_CREATED_TIME)) {
                    loadBalancerDescription.setCreatedTime(DateUtils.toDate(reader.getValue()));
                } else if (name.equals(ELEMENT_ACCOUNTING_TYPE)) {
                    loadBalancerDescription.setAccountingType(reader.getValue());
                } else if (name.equals(ELEMENT_NEXT_MONTH_ACCOUNTING_TYPE)) {
                    loadBalancerDescription.setNextMonthAccountingType(reader.getValue());
                } else if (name.equals(ELEMENT_OPTION)) {
                    loadBalancerDescription.setOption((LoadBalancerOption)optionConverter.unmarshal(reader, context));
                }
                reader.moveUp();
            }
            loadBalancerDescriptions.add(loadBalancerDescription);
            reader.moveUp();
        }
        return loadBalancerDescriptions;
    }

    public void marshal(Object paramObject, HierarchicalStreamWriter paramHierarchicalStreamWriter, MarshallingContext paramMarshallingContext) {
    }
}

