/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.loadbalancer.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;
import com.nifty.cloud.sdk.loadbalancer.model.IpAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Action(value="SetFilterForLoadBalancer")
public class SetFilterForLoadBalancerRequest
implements Request {
    private String loadBalancerName;
    private Integer loadBalancerPort;
    private Integer instancePort;
    private List<IpAddress> ipAddresses;
    private String filterType;

    public SetFilterForLoadBalancerRequest() {
    }

    public SetFilterForLoadBalancerRequest(String loadBalancerName, Integer loadBalancerPort, Integer instancePort) {
        this.loadBalancerName = loadBalancerName;
        this.loadBalancerPort = loadBalancerPort;
        this.instancePort = instancePort;
    }

    @Query(name="LoadBalancerName", require=true)
    public String getLoadBalancerName() {
        return this.loadBalancerName;
    }

    public void setLoadBalancerName(String loadBalancerName) {
        this.loadBalancerName = loadBalancerName;
    }

    public SetFilterForLoadBalancerRequest withLoadBalancerName(String loadBalancerName) {
        this.setLoadBalancerName(loadBalancerName);
        return this;
    }

    @Query(name="LoadBalancerPort", require=true)
    public Integer getLoadBalancerPort() {
        return this.loadBalancerPort;
    }

    public void setLoadBalancerPort(Integer loadBalancerPort) {
        this.loadBalancerPort = loadBalancerPort;
    }

    public SetFilterForLoadBalancerRequest withLoadBalancerPort(Integer loadBalancerPort) {
        this.setLoadBalancerPort(loadBalancerPort);
        return this;
    }

    @Query(name="InstancePort", require=true)
    public Integer getInstancePort() {
        return this.instancePort;
    }

    public void setInstancePort(Integer instancePort) {
        this.instancePort = instancePort;
    }

    public SetFilterForLoadBalancerRequest withInstancePort(Integer instancePort) {
        this.setInstancePort(instancePort);
        return this;
    }

    @Query(name="IPAddresses.member")
    public List<IpAddress> getIpAddresses() {
        return this.ipAddresses;
    }

    public void setIpAddresses(List<IpAddress> ipAddresses) {
        this.ipAddresses = ipAddresses;
    }

    public SetFilterForLoadBalancerRequest withIpAddresses(IpAddress ... ipAddresses) {
        if (this.ipAddresses == null) {
            this.ipAddresses = new ArrayList<IpAddress>();
        }
        for (IpAddress ipAddress : ipAddresses) {
            this.getIpAddresses().add(ipAddress);
        }
        return this;
    }

    public SetFilterForLoadBalancerRequest withIpAddresses(Collection<IpAddress> ipAddresses) {
        if (this.ipAddresses == null) {
            this.ipAddresses = new ArrayList<IpAddress>();
        }
        if (ipAddresses != null) {
            this.getIpAddresses().addAll(ipAddresses);
        }
        return this;
    }

    @Query(name="FilterType")
    public String getFilterType() {
        return this.filterType;
    }

    public void setFilterType(String filterType) {
        this.filterType = filterType;
    }

    public SetFilterForLoadBalancerRequest withFilterType(String filterType) {
        this.setFilterType(filterType);
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[loadBalancerName=");
        builder.append(this.loadBalancerName);
        builder.append(", loadBalancerPort=");
        builder.append(this.loadBalancerPort);
        builder.append(", instancePort=");
        builder.append(this.instancePort);
        builder.append(", ipAddresses=");
        builder.append(this.ipAddresses);
        builder.append(", filterType=");
        builder.append(this.filterType);
        builder.append("]");
        return builder.toString();
    }
}

