/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.loadbalancer.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;
import com.nifty.cloud.sdk.loadbalancer.model.Listener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Action(value="RegisterPortWithLoadBalancer")
public class RegisterPortWithLoadBalancerRequest
implements Request {
    private String loadBalancerName;
    private List<Listener> listeners;

    public RegisterPortWithLoadBalancerRequest() {
    }

    public RegisterPortWithLoadBalancerRequest(String loadBalancerName) {
        this.loadBalancerName = loadBalancerName;
    }

    @Query(name="LoadBalancerName", require=true)
    public String getLoadBalancerName() {
        return this.loadBalancerName;
    }

    public void setLoadBalancerName(String loadBalancerName) {
        this.loadBalancerName = loadBalancerName;
    }

    public RegisterPortWithLoadBalancerRequest withLoadBalancerName(String loadBalancerName) {
        this.setLoadBalancerName(loadBalancerName);
        return this;
    }

    @Query(name="Listeners.member")
    public List<Listener> getListeners() {
        return this.listeners;
    }

    public void setListeners(List<Listener> listeners) {
        this.listeners = listeners;
    }

    public RegisterPortWithLoadBalancerRequest withListeners(Listener ... listeners) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<Listener>();
        }
        for (Listener listener : listeners) {
            this.getListeners().add(listener);
        }
        return this;
    }

    public RegisterPortWithLoadBalancerRequest withListeners(Collection<Listener> listeners) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<Listener>();
        }
        if (listeners != null) {
            this.getListeners().addAll(listeners);
        }
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[loadBalancerName=");
        builder.append(this.loadBalancerName);
        builder.append(", listeners=");
        builder.append(this.listeners);
        builder.append("]");
        return builder.toString();
    }
}

