/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.loadbalancer.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;
import com.nifty.cloud.sdk.loadbalancer.model.Instance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Action(value="DescribeInstanceHealth")
public class DescribeInstanceHealthRequest
implements Request {
    private String loadBalancerName;
    private Integer loadBalancerPort;
    private Integer instancePort;
    private List<Instance> instances;

    public DescribeInstanceHealthRequest() {
    }

    public DescribeInstanceHealthRequest(String loadBalancerName, Integer loadBalancerPort, Integer instancePort) {
        this.loadBalancerName = loadBalancerName;
        this.loadBalancerPort = loadBalancerPort;
        this.instancePort = instancePort;
    }

    @Query(name="LoadBalancerName")
    public String getLoadBalancerName() {
        return this.loadBalancerName;
    }

    public void setLoadBalancerName(String loadBalancerName) {
        this.loadBalancerName = loadBalancerName;
    }

    public DescribeInstanceHealthRequest withLoadBalancerName(String loadBalancerName) {
        this.setLoadBalancerName(loadBalancerName);
        return this;
    }

    @Query(name="LoadBalancerPort")
    public Integer getLoadBalancerPort() {
        return this.loadBalancerPort;
    }

    public void setLoadBalancerPort(Integer loadBalancerPort) {
        this.loadBalancerPort = loadBalancerPort;
    }

    public DescribeInstanceHealthRequest withLoadBalancerPort(Integer loadBalancerPort) {
        this.setLoadBalancerPort(loadBalancerPort);
        return this;
    }

    @Query(name="InstancePort")
    public Integer getInstancePort() {
        return this.instancePort;
    }

    public void setInstancePort(Integer instancePort) {
        this.instancePort = instancePort;
    }

    public DescribeInstanceHealthRequest withInstancePort(Integer instancePort) {
        this.setInstancePort(instancePort);
        return this;
    }

    @Query(name="Instances.member")
    public List<Instance> getInstances() {
        return this.instances;
    }

    public void setInstances(List<Instance> instances) {
        this.instances = instances;
    }

    public DescribeInstanceHealthRequest withInstances(Instance ... instances) {
        if (this.instances == null) {
            this.instances = new ArrayList<Instance>();
        }
        for (Instance instance : instances) {
            this.getInstances().add(instance);
        }
        return this;
    }

    public DescribeInstanceHealthRequest withInstances(Collection<Instance> instances) {
        if (this.instances == null) {
            this.instances = new ArrayList<Instance>();
        }
        if (instances != null) {
            this.getInstances().addAll(instances);
        }
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[loadBalancerName=");
        builder.append(this.loadBalancerName);
        builder.append(", loadBalancerPort=");
        builder.append(this.loadBalancerPort);
        builder.append(", instancePort=");
        builder.append(this.instancePort);
        builder.append(", instances=");
        builder.append(this.instances);
        builder.append("]");
        return builder.toString();
    }
}

