/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.loadbalancer.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;
import com.nifty.cloud.sdk.loadbalancer.model.Listener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Action(value="CreateLoadBalancer")
public class CreateLoadBalancerRequest
implements Request {
    private String loadBalancerName;
    private List<Listener> listeners;
    private List<String> availabilityZones;
    private Integer networkVolume;
    private String ipVersion;
    private String accountingType;
    private String policyType;

    public CreateLoadBalancerRequest() {
    }

    public CreateLoadBalancerRequest(String loadBalancerName) {
        this.loadBalancerName = loadBalancerName;
    }

    @Query(name="LoadBalancerName", require=true)
    public String getLoadBalancerName() {
        return this.loadBalancerName;
    }

    public void setLoadBalancerName(String loadBalancerName) {
        this.loadBalancerName = loadBalancerName;
    }

    public CreateLoadBalancerRequest withLoadBalancerName(String loadBalancerName) {
        this.setLoadBalancerName(loadBalancerName);
        return this;
    }

    @Query(name="Listeners.member")
    public List<Listener> getListeners() {
        return this.listeners;
    }

    public void setListeners(List<Listener> listeners) {
        this.listeners = listeners;
    }

    public CreateLoadBalancerRequest withListeners(Listener ... listeners) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<Listener>();
        }
        for (Listener listener : listeners) {
            this.getListeners().add(listener);
        }
        return this;
    }

    public CreateLoadBalancerRequest withListeners(Collection<Listener> listeners) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<Listener>();
        }
        if (listeners != null) {
            this.getListeners().addAll(listeners);
        }
        return this;
    }

    @Query(name="AvailabilityZones.member")
    public List<String> getAvailabilityZones() {
        return this.availabilityZones;
    }

    public void setAvailabilityZones(List<String> availabilityZones) {
        this.availabilityZones = availabilityZones;
    }

    public CreateLoadBalancerRequest withAvailabilityZones(String ... availabilityZones) {
        if (this.availabilityZones == null) {
            this.availabilityZones = new ArrayList<String>();
        }
        for (String availabilityZone : availabilityZones) {
            this.getAvailabilityZones().add(availabilityZone);
        }
        return this;
    }

    public CreateLoadBalancerRequest withAvailabilityZones(Collection<String> availabilityZones) {
        if (this.availabilityZones == null) {
            this.availabilityZones = new ArrayList<String>();
        }
        if (availabilityZones != null) {
            this.getAvailabilityZones().addAll(availabilityZones);
        }
        return this;
    }

    @Query(name="NetworkVolume")
    public Integer getNetworkVolume() {
        return this.networkVolume;
    }

    public void setNetworkVolume(Integer networkVolume) {
        this.networkVolume = networkVolume;
    }

    public CreateLoadBalancerRequest withNetworkVolume(Integer networkVolume) {
        this.setNetworkVolume(networkVolume);
        return this;
    }

    @Query(name="IpVersion")
    public String getIpVersion() {
        return this.ipVersion;
    }

    public void setIpVersion(String ipVersion) {
        this.ipVersion = ipVersion;
    }

    public CreateLoadBalancerRequest withIpVersion(String ipVersion) {
        this.setIpVersion(ipVersion);
        return this;
    }

    @Query(name="AccountingType")
    public String getAccountingType() {
        return this.accountingType;
    }

    public void setAccountingType(String accountingType) {
        this.accountingType = accountingType;
    }

    public CreateLoadBalancerRequest withAccountingType(String accountingType) {
        this.setAccountingType(accountingType);
        return this;
    }

    @Query(name="PolicyType")
    public String getPolicyType() {
        return this.policyType;
    }

    public void setPolicyType(String policyType) {
        this.policyType = policyType;
    }

    public CreateLoadBalancerRequest withPolicyType(String policyType) {
        this.setPolicyType(policyType);
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[loadBalancerName=");
        builder.append(this.loadBalancerName);
        builder.append(", listeners=");
        builder.append(this.listeners);
        builder.append(", availabilityZones=");
        builder.append(this.availabilityZones);
        builder.append(", networkVolume=");
        builder.append(this.networkVolume);
        builder.append(", ipVersion=");
        builder.append(this.ipVersion);
        builder.append(", accountingType=");
        builder.append(this.accountingType);
        builder.append(", policyType=");
        builder.append(this.policyType);
        builder.append("]");
        return builder.toString();
    }
}

