/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.image.model.transform;

import com.nifty.cloud.sdk.image.model.GlobalPlacement;
import com.nifty.cloud.sdk.image.model.Image;
import com.nifty.cloud.sdk.image.model.StateReason;
import com.nifty.cloud.sdk.image.model.transform.BlockDeviceMappingConverter;
import com.nifty.cloud.sdk.image.model.transform.PlacementConverter;
import com.nifty.cloud.sdk.image.model.transform.ProductCodesSetConverter;
import com.nifty.cloud.sdk.image.model.transform.StateReasonConverter;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.ArrayList;
import java.util.List;

public class DescribeImagesConverter
implements Converter {
    private static final String ELEMENT_IMAGE_ID = "imageId";
    private static final String ELEMENT_IMAGE_LOCATION = "imageLocation";
    private static final String ELEMENT_IMAGE_STATE = "imageState";
    private static final String ELEMENT_IMAGE_OWNER_ID = "imageOwnerId";
    private static final String ELEMENT_ID_PUBLIC = "isPublic";
    private static final String ELEMENT_PRODUCT_CODES = "productCodes";
    private static final String ELEMENT_ARCHITECTURE = "architecture";
    private static final String ELEMENT_IMAGE_TYPE = "imageType";
    private static final String ELEMENT_KERNEL_ID = "kernelId";
    private static final String ELEMENT_RAMDISK_ID = "ramdiskId";
    private static final String ELEMENT_PLATFORM = "platform";
    private static final String ELEMENT_STATE_REASON = "stateReason";
    private static final String ELEMENT_IMAGE_OWNER_ALIAS = "imageOwnerAlias";
    private static final String ELEMENT_NAME = "name";
    private static final String ELEMENT_DESCRIPTION = "description";
    private static final String ELEMENT_DETAIL_DESCRIPTION = "detailDescription";
    private static final String ELEMENT_REDISTRIBUTABLE = "redistributable";
    private static final String ELEMENT_PLACEMENT = "placement";
    private static final String ELEMENT_ROOT_DEVICE_TYPE = "rootDeviceType";
    private static final String ELEMENT_ROOT_DEVICE_NAME = "rootDeviceName";
    private static final String ELEMENT_BLOCK_DEVICE_MAPPING = "blockDeviceMapping";

    public boolean canConvert(Class clazz) {
        Class<?>[] interfaces;
        for (Class<?> i : interfaces = clazz.getInterfaces()) {
            if (i != List.class) continue;
            return true;
        }
        return false;
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        ArrayList<Image> images = new ArrayList<Image>();
        ProductCodesSetConverter productCodeConverter = new ProductCodesSetConverter();
        StateReasonConverter stateReasonConverter = new StateReasonConverter();
        PlacementConverter placementConverter = new PlacementConverter();
        BlockDeviceMappingConverter blockDeviceConverter = new BlockDeviceMappingConverter();
        String name = null;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            Image image = new Image();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                name = reader.getNodeName();
                if (name.equals(ELEMENT_IMAGE_ID)) {
                    image.setImageId(reader.getValue());
                } else if (name.equals(ELEMENT_IMAGE_LOCATION)) {
                    image.setImageLocation(reader.getValue());
                } else if (name.equals(ELEMENT_IMAGE_STATE)) {
                    image.setState(reader.getValue());
                } else if (name.equals(ELEMENT_IMAGE_OWNER_ID)) {
                    image.setOwnerId(reader.getValue());
                } else if (name.equals(ELEMENT_ID_PUBLIC)) {
                    image.setPublicValue(Boolean.valueOf(reader.getValue()));
                } else if (name.equals(ELEMENT_PRODUCT_CODES)) {
                    image.setProductCodes((List)productCodeConverter.unmarshal(reader, context));
                } else if (name.equals(ELEMENT_ARCHITECTURE)) {
                    image.setArchitecture(reader.getValue());
                } else if (name.equals(ELEMENT_IMAGE_TYPE)) {
                    image.setImageType(reader.getValue());
                } else if (name.equals(ELEMENT_KERNEL_ID)) {
                    image.setKernelId(reader.getValue());
                } else if (name.equals(ELEMENT_RAMDISK_ID)) {
                    image.setRamdiskId(reader.getValue());
                } else if (name.equals(ELEMENT_PLATFORM)) {
                    image.setPlatform(reader.getValue());
                } else if (name.equals(ELEMENT_STATE_REASON)) {
                    image.setStateReason((StateReason)stateReasonConverter.unmarshal(reader, context));
                } else if (name.equals(ELEMENT_IMAGE_OWNER_ALIAS)) {
                    image.setImageOwnerAlias(reader.getValue());
                } else if (name.equals(ELEMENT_NAME)) {
                    image.setName(reader.getValue());
                } else if (name.equals(ELEMENT_DESCRIPTION)) {
                    image.setDescription(reader.getValue());
                } else if (name.equals(ELEMENT_DETAIL_DESCRIPTION)) {
                    image.setDetailDescription(reader.getValue());
                } else if (name.equals(ELEMENT_REDISTRIBUTABLE)) {
                    image.setRedistributable(Boolean.valueOf(reader.getValue()));
                } else if (name.equals(ELEMENT_PLACEMENT)) {
                    image.setPlacement((GlobalPlacement)placementConverter.unmarshal(reader, context));
                } else if (name.equals(ELEMENT_ROOT_DEVICE_TYPE)) {
                    image.setRootDeviceType(reader.getValue());
                } else if (name.equals(ELEMENT_ROOT_DEVICE_NAME)) {
                    image.setRootDeviceName(reader.getValue());
                } else if (name.equals(ELEMENT_BLOCK_DEVICE_MAPPING)) {
                    image.setBlockDeviceMappings((List)blockDeviceConverter.unmarshal(reader, context));
                }
                reader.moveUp();
            }
            images.add(image);
            reader.moveUp();
        }
        return images;
    }

    public void marshal(Object paramObject, HierarchicalStreamWriter paramHierarchicalStreamWriter, MarshallingContext paramMarshallingContext) {
    }
}

