/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.image.model.transform;

import com.nifty.cloud.sdk.image.model.BlockDeviceMapping;
import com.nifty.cloud.sdk.image.model.EbsBlockDevice;
import com.nifty.cloud.sdk.image.model.transform.EbsBlockDeviceConverter;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.ArrayList;
import java.util.List;

public class BlockDeviceMappingConverter
implements Converter {
    private static final String ELEMENT_DEVICE_NAME = "deviceName";
    private static final String ELEMENT_VIRTUAL_NAME = "virtualName";
    private static final String ELEMENT_EBS = "ebs";
    private static final String ELEMENT_NO_DEVICE = "noDevice";

    public boolean canConvert(Class clazz) {
        Class<?>[] interfaces;
        for (Class<?> i : interfaces = clazz.getInterfaces()) {
            if (i != List.class) continue;
            return true;
        }
        return false;
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        ArrayList<BlockDeviceMapping> blockDeviceMappings = new ArrayList<BlockDeviceMapping>();
        EbsBlockDeviceConverter converter = new EbsBlockDeviceConverter();
        String name = null;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            BlockDeviceMapping blockDeviceMapping = new BlockDeviceMapping();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                name = reader.getNodeName();
                if (name.equals(ELEMENT_DEVICE_NAME)) {
                    blockDeviceMapping.setDeviceName(reader.getValue());
                } else if (name.equals(ELEMENT_VIRTUAL_NAME)) {
                    blockDeviceMapping.setVirtualName(reader.getValue());
                } else if (name.equals(ELEMENT_EBS)) {
                    blockDeviceMapping.setEbs((EbsBlockDevice)converter.unmarshal(reader, context));
                } else if (name.equals(ELEMENT_NO_DEVICE)) {
                    blockDeviceMapping.setNoDevice(reader.getValue());
                }
                reader.moveUp();
            }
            blockDeviceMappings.add(blockDeviceMapping);
            reader.moveUp();
        }
        return blockDeviceMappings;
    }

    public void marshal(Object paramObject, HierarchicalStreamWriter paramHierarchicalStreamWriter, MarshallingContext paramMarshallingContext) {
    }
}

