/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.image;

import com.nifty.cloud.sdk.ClientConfiguration;
import com.nifty.cloud.sdk.auth.Credentials;
import com.nifty.cloud.sdk.image.NiftyImageAsync;
import com.nifty.cloud.sdk.image.NiftyImageClient;
import com.nifty.cloud.sdk.image.model.DeleteImageRequest;
import com.nifty.cloud.sdk.image.model.DeleteImageResult;
import com.nifty.cloud.sdk.image.model.DescribeImagesRequest;
import com.nifty.cloud.sdk.image.model.DescribeImagesResult;
import com.nifty.cloud.sdk.image.model.ModifyImageAttributeRequest;
import com.nifty.cloud.sdk.image.model.ModifyImageAttributeResult;
import com.nifty.cloud.sdk.image.model.NiftyAssociateImageRequest;
import com.nifty.cloud.sdk.image.model.NiftyAssociateImageResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class NiftyImageAsyncClient
extends NiftyImageClient
implements NiftyImageAsync {
    protected ExecutorService executorService = null;

    public NiftyImageAsyncClient(Credentials credential) {
        this(credential, Executors.newCachedThreadPool());
    }

    public NiftyImageAsyncClient(Credentials credential, ClientConfiguration configuration) {
        this(credential, configuration, Executors.newCachedThreadPool());
    }

    public NiftyImageAsyncClient(Credentials credential, ExecutorService executorService) {
        super(credential);
        this.executorService = executorService;
    }

    public NiftyImageAsyncClient(Credentials credential, ClientConfiguration configuration, ExecutorService executorService) {
        super(credential, configuration);
        this.executorService = executorService;
    }

    @Override
    public Future<DeleteImageResult> deleteImageAsync(final DeleteImageRequest request) {
        return this.executorService.submit(new Callable<DeleteImageResult>(){

            @Override
            public DeleteImageResult call() {
                return NiftyImageAsyncClient.this.deleteImage(request);
            }
        });
    }

    @Override
    public Future<DescribeImagesResult> describeImagesAsync(final DescribeImagesRequest request) {
        return this.executorService.submit(new Callable<DescribeImagesResult>(){

            @Override
            public DescribeImagesResult call() {
                return NiftyImageAsyncClient.this.describeImages(request);
            }
        });
    }

    @Override
    public Future<ModifyImageAttributeResult> modifyImageAttributeAsync(final ModifyImageAttributeRequest request) {
        return this.executorService.submit(new Callable<ModifyImageAttributeResult>(){

            @Override
            public ModifyImageAttributeResult call() {
                return NiftyImageAsyncClient.this.modifyImageAttribute(request);
            }
        });
    }

    @Override
    public Future<NiftyAssociateImageResult> niftyAssociateImageAsync(final NiftyAssociateImageRequest request) {
        return this.executorService.submit(new Callable<NiftyAssociateImageResult>(){

            @Override
            public NiftyAssociateImageResult call() {
                return NiftyImageAsyncClient.this.niftyAssociateImage(request);
            }
        });
    }
}

