/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.firewall.model.transform;

import com.nifty.cloud.sdk.firewall.model.SecurityGroup;
import com.nifty.cloud.sdk.firewall.model.transform.InstanceNetworkInterfaceConverter;
import com.nifty.cloud.sdk.firewall.model.transform.InstancesConverter;
import com.nifty.cloud.sdk.firewall.model.transform.IpPermissionConverter;
import com.nifty.cloud.sdk.firewall.model.transform.RouterConverter;
import com.nifty.cloud.sdk.firewall.model.transform.RouterNetworkInterfaceConverter;
import com.nifty.cloud.sdk.firewall.model.transform.VpnGatewayConverter;
import com.nifty.cloud.sdk.firewall.model.transform.VpnGatewayNetworkInterfaceConverter;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.ArrayList;
import java.util.List;

public class SecurityGroupConverter
implements Converter {
    private static final String ELEMENT_OWNER_ID = "ownerId";
    private static final String ELEMENT_GROUP_NAME = "groupName";
    private static final String ELEMENT_GROUP_DESCRIPTION = "groupDescription";
    private static final String ELEMENT_GROUP_STATUS = "groupStatus";
    private static final String ELEMENT_IP_PERMISSION = "ipPermissions";
    private static final String ELEMENT_INSTANCES_SET = "instancesSet";
    private static final String INSTANCES_NETWORK_INTERFACE_SET = "instancesNetworkInterfaceSet";
    private static final String ROUTER_SET = "routerSet";
    private static final String ROUTER_NETWORK_INTERFACE_SET = "routerNetworkInterfaceSet";
    private static final String VPN_GATEWAY_SET = "vpnGatewaySet";
    private static final String VPN_GATEWAY_NETWORK_INTERFACE_SET = "vpnGatewayNetworkInterfaceSet";
    private static final String ELEMENT_GROUP_RULE_LIMIT = "groupRuleLimit";
    private static final String ELEMENT_GROUP_LOG_LIMIT = "groupLogLimit";
    private static final String ELEMENT_GROUP_LOG_FILTER_NET_BIOS = "groupLogFilterNetBios";
    private static final String ELEMENT_AVAILABILITY_ZONE = "availabilityZone";

    public boolean canConvert(Class clazz) {
        Class<?>[] interfaces;
        for (Class<?> i : interfaces = clazz.getInterfaces()) {
            if (i != List.class) continue;
            return true;
        }
        return false;
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        ArrayList<SecurityGroup> securityGroupss = new ArrayList<SecurityGroup>();
        IpPermissionConverter permissionConverter = new IpPermissionConverter();
        InstancesConverter instanceConverter = new InstancesConverter();
        InstanceNetworkInterfaceConverter instanceNetworkInterfaceConverter = new InstanceNetworkInterfaceConverter();
        RouterConverter routerConverter = new RouterConverter();
        RouterNetworkInterfaceConverter routerNetworkInterfaceConverter = new RouterNetworkInterfaceConverter();
        VpnGatewayConverter vpnGatewayConverter = new VpnGatewayConverter();
        VpnGatewayNetworkInterfaceConverter vpnGatewayNetworkInterfaceConverter = new VpnGatewayNetworkInterfaceConverter();
        String name = null;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            SecurityGroup securityGroups = new SecurityGroup();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                name = reader.getNodeName();
                if (name.equals(ELEMENT_OWNER_ID)) {
                    securityGroups.setOwnerId(reader.getValue());
                } else if (name.equals(ELEMENT_GROUP_NAME)) {
                    securityGroups.setGroupName(reader.getValue());
                } else if (name.equals(ELEMENT_GROUP_DESCRIPTION)) {
                    securityGroups.setGroupDescription(reader.getValue());
                } else if (name.equals(ELEMENT_GROUP_STATUS)) {
                    securityGroups.setGroupStatus(reader.getValue());
                } else if (name.equals(ELEMENT_IP_PERMISSION)) {
                    securityGroups.setIpPermissions((List)permissionConverter.unmarshal(reader, context));
                } else if (name.equals(ELEMENT_INSTANCES_SET)) {
                    securityGroups.setInstanceIds((List)instanceConverter.unmarshal(reader, context));
                } else if (name.equals(INSTANCES_NETWORK_INTERFACE_SET)) {
                    securityGroups.setInstanceNetworkInterfaces((List)instanceNetworkInterfaceConverter.unmarshal(reader, context));
                } else if (name.equals(ROUTER_SET)) {
                    securityGroups.setRouters((List)routerConverter.unmarshal(reader, context));
                } else if (name.equals(ROUTER_NETWORK_INTERFACE_SET)) {
                    securityGroups.setRouterNetworkInterfaces((List)routerNetworkInterfaceConverter.unmarshal(reader, context));
                } else if (name.equals(VPN_GATEWAY_SET)) {
                    securityGroups.setVpnGateways((List)vpnGatewayConverter.unmarshal(reader, context));
                } else if (name.equals(VPN_GATEWAY_NETWORK_INTERFACE_SET)) {
                    securityGroups.setVpnGatewayNetworkInterfaces((List)vpnGatewayNetworkInterfaceConverter.unmarshal(reader, context));
                } else if (name.equals(ELEMENT_GROUP_RULE_LIMIT)) {
                    securityGroups.setGroupRuleLimit(Integer.valueOf(reader.getValue()));
                } else if (name.equals(ELEMENT_GROUP_LOG_LIMIT)) {
                    securityGroups.setGroupLogLimit(Integer.valueOf(reader.getValue()));
                } else if (name.equals(ELEMENT_GROUP_LOG_FILTER_NET_BIOS)) {
                    securityGroups.setGroupLogFilterNetBios(Boolean.valueOf(reader.getValue()));
                } else if (name.equals(ELEMENT_AVAILABILITY_ZONE)) {
                    securityGroups.setAvailabilityZone(reader.getValue());
                }
                reader.moveUp();
            }
            reader.moveUp();
            securityGroupss.add(securityGroups);
        }
        return securityGroupss;
    }

    public void marshal(Object paramObject, HierarchicalStreamWriter paramHierarchicalStreamWriter, MarshallingContext paramMarshallingContext) {
    }
}

