/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.firewall.model.transform;

import com.nifty.cloud.sdk.firewall.model.IpPermission;
import com.nifty.cloud.sdk.firewall.model.transform.GroupsConverter;
import com.nifty.cloud.sdk.firewall.model.transform.IpRangeConverter;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.ArrayList;
import java.util.List;

public class IpPermissionConverter
implements Converter {
    private static final String ELEMENT_IP_PROTOCOL = "ipProtocol";
    private static final String ELEMENT_FROM_PORT = "fromPort";
    private static final String ELEMENT_TO_PORT = "toPort";
    private static final String ELEMENT_IN_OUT = "inOut";
    private static final String ELEMENT_GROUPS = "groups";
    private static final String ELEMENT_IP_RANGE = "ipRanges";

    public boolean canConvert(Class clazz) {
        Class<?>[] interfaces;
        for (Class<?> i : interfaces = clazz.getInterfaces()) {
            if (i != List.class) continue;
            return true;
        }
        return false;
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        ArrayList<IpPermission> permissions = new ArrayList<IpPermission>();
        GroupsConverter groupConverter = new GroupsConverter();
        IpRangeConverter ipRangeConverter = new IpRangeConverter();
        String name = null;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            IpPermission permission = new IpPermission();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                name = reader.getNodeName();
                if (name.equals(ELEMENT_IP_PROTOCOL)) {
                    permission.setIpProtocol(reader.getValue());
                } else if (name.equals(ELEMENT_FROM_PORT)) {
                    permission.setFromPort(new Integer(reader.getValue()));
                } else if (name.equals(ELEMENT_TO_PORT)) {
                    permission.setToPort(new Integer(reader.getValue()));
                } else if (name.equals(ELEMENT_IN_OUT)) {
                    permission.setInOut(reader.getValue());
                } else if (name.equals(ELEMENT_GROUPS)) {
                    permission.setGroups((List)groupConverter.unmarshal(reader, context));
                } else if (name.equals(ELEMENT_IP_RANGE)) {
                    permission.setIpRanges((List)ipRangeConverter.unmarshal(reader, context));
                }
                reader.moveUp();
            }
            reader.moveUp();
            permissions.add(permission);
        }
        return permissions;
    }

    public void marshal(Object paramObject, HierarchicalStreamWriter paramHierarchicalStreamWriter, MarshallingContext paramMarshallingContext) {
    }
}

