/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.firewall.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;
import com.nifty.cloud.sdk.firewall.model.IpPermission;
import java.util.ArrayList;
import java.util.List;

@Action(value="RevokeSecurityGroupIngress")
public class RevokeSecurityGroupIngressRequest
implements Request {
    private String userId;
    private String groupName;
    private List<IpPermission> ipPermissions;

    public RevokeSecurityGroupIngressRequest() {
    }

    public RevokeSecurityGroupIngressRequest(String groupName, List<IpPermission> ipPermissions) {
        this.groupName = groupName;
        this.ipPermissions = ipPermissions;
    }

    @Query(name="UserId")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public RevokeSecurityGroupIngressRequest withtUserId(String userId) {
        this.userId = userId;
        return this;
    }

    @Query(name="GroupName", require=true)
    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public RevokeSecurityGroupIngressRequest withGroupName(String groupName) {
        this.setGroupName(groupName);
        return this;
    }

    @Query(name="IpPermissions", require=true)
    public List<IpPermission> getIpPermissions() {
        return this.ipPermissions;
    }

    public void setIpPermissions(List<IpPermission> ipPermissions) {
        this.ipPermissions = ipPermissions;
    }

    public RevokeSecurityGroupIngressRequest withIpPermissions(IpPermission ... ipPermissions) {
        if (this.ipPermissions == null) {
            this.ipPermissions = new ArrayList<IpPermission>();
        }
        for (IpPermission ipPermission : ipPermissions) {
            this.getIpPermissions().add(ipPermission);
        }
        return this;
    }

    public RevokeSecurityGroupIngressRequest withIpPermissions(List<IpPermission> ipPermissions) {
        if (this.ipPermissions == null) {
            this.ipPermissions = new ArrayList<IpPermission>();
        }
        if (ipPermissions != null) {
            this.getIpPermissions().addAll(ipPermissions);
        }
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[groupName=");
        builder.append(this.groupName);
        builder.append(", ipPermissions=");
        builder.append(this.ipPermissions);
        builder.append("]");
        return builder.toString();
    }
}

