/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.firewall.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;
import com.nifty.cloud.sdk.firewall.model.RouterIdSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Action(value="NiftyDeregisterRoutersFromSecurityGroup")
public class NiftyDeregisterRoutersFromSecurityGroupRequest
implements Request {
    private String groupName;
    private List<RouterIdSet> routers;

    public NiftyDeregisterRoutersFromSecurityGroupRequest() {
    }

    public NiftyDeregisterRoutersFromSecurityGroupRequest(String groupName, List<RouterIdSet> routers) {
        this.groupName = groupName;
        this.routers = routers;
    }

    @Query(name="GroupName", require=true)
    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public NiftyDeregisterRoutersFromSecurityGroupRequest withGroupName(String groupName) {
        this.setGroupName(groupName);
        return this;
    }

    @Query(name="RouterSet", require=true)
    public List<RouterIdSet> getRouters() {
        return this.routers;
    }

    public void setRouters(List<RouterIdSet> routers) {
        this.routers = routers;
    }

    public NiftyDeregisterRoutersFromSecurityGroupRequest withRouters(RouterIdSet ... routers) {
        if (this.routers == null) {
            this.routers = new ArrayList<RouterIdSet>();
        }
        for (RouterIdSet router : routers) {
            this.getRouters().add(router);
        }
        return this;
    }

    public NiftyDeregisterRoutersFromSecurityGroupRequest withRouters(Collection<RouterIdSet> routers) {
        if (this.routers == null) {
            this.routers = new ArrayList<RouterIdSet>();
        }
        if (routers != null) {
            this.getRouters().addAll(routers);
        }
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[groupName=");
        builder.append(this.groupName);
        builder.append(", routers=");
        builder.append(this.routers);
        builder.append("]");
        return builder.toString();
    }
}

