/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.firewall.model;

import com.nifty.cloud.sdk.annotation.Query;
import com.nifty.cloud.sdk.firewall.model.IpRange;
import com.nifty.cloud.sdk.firewall.model.UserIdGroupPair;
import java.util.ArrayList;
import java.util.List;

public class IpPermission {
    private String ipProtocol;
    private Integer fromPort;
    private Integer toPort;
    private String inOut;
    private List<UserIdGroupPair> groups;
    private List<IpRange> ipRanges;

    @Query(name="IpProtocol")
    public String getIpProtocol() {
        return this.ipProtocol;
    }

    public void setIpProtocol(String ipProtocol) {
        this.ipProtocol = ipProtocol;
    }

    public IpPermission withIpProtocol(String ipProtocol) {
        this.ipProtocol = ipProtocol;
        return this;
    }

    @Query(name="FromPort")
    public Integer getFromPort() {
        return this.fromPort;
    }

    public void setFromPort(Integer fromPort) {
        this.fromPort = fromPort;
    }

    public IpPermission withFromPort(Integer fromPort) {
        this.setFromPort(fromPort);
        return this;
    }

    @Query(name="ToPort")
    public Integer getToPort() {
        return this.toPort;
    }

    public void setToPort(Integer toPort) {
        this.toPort = toPort;
    }

    public IpPermission withToPort(Integer toPort) {
        this.setToPort(toPort);
        return this;
    }

    @Query(name="InOut")
    public String getInOut() {
        return this.inOut;
    }

    public void setInOut(String inOut) {
        this.inOut = inOut;
    }

    public IpPermission withInOut(String inOut) {
        this.setInOut(inOut);
        return this;
    }

    @Query(name="Groups")
    public List<UserIdGroupPair> getGroups() {
        return this.groups;
    }

    public void setGroups(List<UserIdGroupPair> groups) {
        this.groups = groups;
    }

    public IpPermission withGroups(UserIdGroupPair ... groups) {
        if (this.groups == null) {
            this.groups = new ArrayList<UserIdGroupPair>();
        }
        for (UserIdGroupPair group : groups) {
            this.getGroups().add(group);
        }
        return this;
    }

    public IpPermission withGroups(List<UserIdGroupPair> groups) {
        if (this.groups == null) {
            this.groups = new ArrayList<UserIdGroupPair>();
        }
        if (groups != null) {
            this.getGroups().addAll(groups);
        }
        return this;
    }

    @Query(name="IpRanges")
    public List<IpRange> getIpRanges() {
        return this.ipRanges;
    }

    public void setIpRanges(List<IpRange> ipRanges) {
        this.ipRanges = ipRanges;
    }

    public IpPermission withIpRanges(IpRange ... ipRanges) {
        if (this.ipRanges == null) {
            this.ipRanges = new ArrayList<IpRange>();
        }
        for (IpRange ipRange : ipRanges) {
            this.getIpRanges().add(ipRange);
        }
        return this;
    }

    public IpPermission withIpRanges(List<IpRange> ipRanges) {
        if (this.ipRanges == null) {
            this.ipRanges = new ArrayList<IpRange>();
        }
        if (ipRanges != null) {
            this.getIpRanges().addAll(ipRanges);
        }
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[ipProtocol=");
        builder.append(this.ipProtocol);
        builder.append(", fromPort=");
        builder.append(this.fromPort);
        builder.append(", toPort=");
        builder.append(this.toPort);
        builder.append(", inOut=");
        builder.append(this.inOut);
        builder.append(", groups=");
        builder.append(this.groups);
        builder.append(", ipRanges=");
        builder.append(this.ipRanges);
        builder.append("]");
        return builder.toString();
    }
}

