/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.firewall.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;
import java.util.ArrayList;
import java.util.List;

@Action(value="DeregisterInstancesFromSecurityGroup")
public class DeregisterInstancesFromSecurityGroupRequest
implements Request {
    private String groupName;
    private List<String> instanceIds;

    public DeregisterInstancesFromSecurityGroupRequest() {
    }

    public DeregisterInstancesFromSecurityGroupRequest(String groupName, List<String> instanceIds) {
        this.groupName = groupName;
        this.instanceIds = instanceIds;
    }

    @Query(name="GroupName", require=true)
    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public DeregisterInstancesFromSecurityGroupRequest withGroupName(String groupName) {
        this.setGroupName(groupName);
        return this;
    }

    @Query(name="InstanceId", require=true)
    public List<String> getInstanceIds() {
        return this.instanceIds;
    }

    public void setInstanceIds(List<String> instanceIds) {
        this.instanceIds = instanceIds;
    }

    public DeregisterInstancesFromSecurityGroupRequest withInstanceIds(String ... instanceIds) {
        if (this.instanceIds == null) {
            this.instanceIds = new ArrayList<String>();
        }
        for (String instanceId : instanceIds) {
            this.getInstanceIds().add(instanceId);
        }
        return this;
    }

    public DeregisterInstancesFromSecurityGroupRequest withInstanceIds(List<String> instanceIds) {
        if (this.instanceIds == null) {
            this.instanceIds = new ArrayList<String>();
        }
        if (instanceIds != null) {
            this.getInstanceIds().addAll(instanceIds);
        }
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[groupName=");
        builder.append(this.groupName);
        builder.append(", instanceIds=");
        builder.append(this.instanceIds);
        builder.append("]");
        return builder.toString();
    }
}

