/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.disk.model.transform;

import com.nifty.cloud.sdk.disk.model.Volume;
import com.nifty.cloud.sdk.disk.model.transform.AttachmentSetConverter;
import com.nifty.cloud.sdk.tools.DateUtils;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.ArrayList;
import java.util.List;

public class DescribeVolumesSetConverter
implements Converter {
    private static final String ELEMENT_VOLUME_ID = "volumeId";
    private static final String ELEMENT_SIZE = "size";
    private static final String ELEMENT_DISK_TYPE = "diskType";
    private static final String ELEMENT_SNAPSHOT_ID = "snapshotId";
    private static final String ELEMENT_AVAILABILITY_ZONE = "availabilityZone";
    private static final String ELEMENT_STATUS = "status";
    private static final String ELEMENT_CREATE_TIME = "createTime";
    private static final String ELEMENT_ACCOUNTING_TYPE = "accountingType";
    private static final String ELEMENT_NEXT_MONTH_ACCOUNTING_TYPE = "nextMonthAccountingType";
    private static final String ELEMENT_ATTACHMENT_SET = "attachmentSet";

    public boolean canConvert(Class clazz) {
        Class<?>[] interfaces;
        for (Class<?> i : interfaces = clazz.getInterfaces()) {
            if (i != List.class) continue;
            return true;
        }
        return false;
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        ArrayList<Volume> volumes = new ArrayList<Volume>();
        AttachmentSetConverter attachmentSetConverter = new AttachmentSetConverter();
        String name = null;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            Volume volume = new Volume();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                name = reader.getNodeName();
                if (name.equals(ELEMENT_VOLUME_ID)) {
                    volume.setVolumeId(reader.getValue());
                } else if (name.equals(ELEMENT_SIZE)) {
                    volume.setSize(reader.getValue());
                } else if (name.equals(ELEMENT_DISK_TYPE)) {
                    volume.setDiskType(reader.getValue());
                } else if (name.equals(ELEMENT_SNAPSHOT_ID)) {
                    volume.setSnapshotId(reader.getValue());
                } else if (name.equals(ELEMENT_AVAILABILITY_ZONE)) {
                    volume.setAvailabilityZone(reader.getValue());
                } else if (name.equals(ELEMENT_STATUS)) {
                    volume.setStatus(reader.getValue());
                } else if (name.equals(ELEMENT_CREATE_TIME)) {
                    volume.setCreateTime(DateUtils.toDate(reader.getValue()));
                } else if (name.equals(ELEMENT_ACCOUNTING_TYPE)) {
                    volume.setAccountingType(reader.getValue());
                } else if (name.equals(ELEMENT_NEXT_MONTH_ACCOUNTING_TYPE)) {
                    volume.setNextMonthAccountingType(reader.getValue());
                } else if (name.equals(ELEMENT_ATTACHMENT_SET)) {
                    volume.setAttachments((List)attachmentSetConverter.unmarshal(reader, context));
                }
                reader.moveUp();
            }
            reader.moveUp();
            volumes.add(volume);
        }
        return volumes;
    }

    public void marshal(Object paramObject, HierarchicalStreamWriter paramHierarchicalStreamWriter, MarshallingContext paramMarshallingContext) {
    }
}

