/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.disk;

import com.nifty.cloud.sdk.ClientConfiguration;
import com.nifty.cloud.sdk.auth.Credentials;
import com.nifty.cloud.sdk.disk.NiftyDiscAsync;
import com.nifty.cloud.sdk.disk.NiftyDiskClient;
import com.nifty.cloud.sdk.disk.model.AttachVolumeRequest;
import com.nifty.cloud.sdk.disk.model.AttachVolumeResult;
import com.nifty.cloud.sdk.disk.model.CreateVolumeRequest;
import com.nifty.cloud.sdk.disk.model.CreateVolumeResult;
import com.nifty.cloud.sdk.disk.model.DeleteVolumeRequest;
import com.nifty.cloud.sdk.disk.model.DeleteVolumeResult;
import com.nifty.cloud.sdk.disk.model.DescribeVolumesRequest;
import com.nifty.cloud.sdk.disk.model.DescribeVolumesResult;
import com.nifty.cloud.sdk.disk.model.DetachVolumeRequest;
import com.nifty.cloud.sdk.disk.model.DetachVolumeResult;
import com.nifty.cloud.sdk.disk.model.ExtendVolumeSizeRequest;
import com.nifty.cloud.sdk.disk.model.ExtendVolumeSizeResult;
import com.nifty.cloud.sdk.disk.model.ModifyVolumeAttributeRequest;
import com.nifty.cloud.sdk.disk.model.ModifyVolumeAttributeResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class NiftyDiskAsyncClient
extends NiftyDiskClient
implements NiftyDiscAsync {
    protected ExecutorService executorService = null;

    public NiftyDiskAsyncClient(Credentials credential) {
        this(credential, Executors.newCachedThreadPool());
    }

    public NiftyDiskAsyncClient(Credentials credential, ClientConfiguration configuration) {
        this(credential, configuration, Executors.newCachedThreadPool());
    }

    public NiftyDiskAsyncClient(Credentials credential, ExecutorService executorService) {
        super(credential);
        this.executorService = executorService;
    }

    public NiftyDiskAsyncClient(Credentials credential, ClientConfiguration configuration, ExecutorService executorService) {
        super(credential, configuration);
        this.executorService = executorService;
    }

    @Override
    public Future<AttachVolumeResult> attachVolumeAsync(final AttachVolumeRequest request) {
        return this.executorService.submit(new Callable<AttachVolumeResult>(){

            @Override
            public AttachVolumeResult call() {
                return NiftyDiskAsyncClient.this.attachVolume(request);
            }
        });
    }

    @Override
    public Future<CreateVolumeResult> createVolumeAsync(final CreateVolumeRequest request) {
        return this.executorService.submit(new Callable<CreateVolumeResult>(){

            @Override
            public CreateVolumeResult call() {
                return NiftyDiskAsyncClient.this.createVolume(request);
            }
        });
    }

    @Override
    public Future<DeleteVolumeResult> deleteVolumeAsync(final DeleteVolumeRequest request) {
        return this.executorService.submit(new Callable<DeleteVolumeResult>(){

            @Override
            public DeleteVolumeResult call() {
                return NiftyDiskAsyncClient.this.deleteVolume(request);
            }
        });
    }

    @Override
    public Future<DescribeVolumesResult> describeVolumesAsync(final DescribeVolumesRequest request) {
        return this.executorService.submit(new Callable<DescribeVolumesResult>(){

            @Override
            public DescribeVolumesResult call() {
                return NiftyDiskAsyncClient.this.describeVolumes(request);
            }
        });
    }

    @Override
    public Future<DetachVolumeResult> detachVolumeAsync(final DetachVolumeRequest request) {
        return this.executorService.submit(new Callable<DetachVolumeResult>(){

            @Override
            public DetachVolumeResult call() {
                return NiftyDiskAsyncClient.this.detachVolume(request);
            }
        });
    }

    @Override
    public Future<ModifyVolumeAttributeResult> modifyVolumeAttributeAsync(final ModifyVolumeAttributeRequest request) {
        return this.executorService.submit(new Callable<ModifyVolumeAttributeResult>(){

            @Override
            public ModifyVolumeAttributeResult call() {
                return NiftyDiskAsyncClient.this.modifyVolumeAttribute(request);
            }
        });
    }

    @Override
    public Future<ExtendVolumeSizeResult> extendVolumeSizeAsync(final ExtendVolumeSizeRequest request) {
        return this.executorService.submit(new Callable<ExtendVolumeSizeResult>(){

            @Override
            public ExtendVolumeSizeResult call() {
                return NiftyDiskAsyncClient.this.extendVolumeSize(request);
            }
        });
    }
}

