/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.dhcp.model.transform;

import com.nifty.cloud.sdk.dhcp.model.DhcpIpAddress;
import com.nifty.cloud.sdk.tools.DateUtils;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.ArrayList;
import java.util.List;

public class DhcpIpAddressSetConverter
implements Converter {
    private static final String ELEMENT_IP_ADDRESS = "ipAddress";
    private static final String ELEMENT_MAC_ADDRESS = "macAddress";
    private static final String ELEMENT_LEASE_TYPE = "leaseType";
    private static final String ELEMENT_LEASE_EXPIRATION = "leaseExpiration";
    private static final String ELEMENT_CLIENT_NAME = "clientName";
    private static final String ELEMENT_DESCRIPTION = "description";

    public boolean canConvert(Class clazz) {
        Class<?>[] interfaces;
        for (Class<?> i : interfaces = clazz.getInterfaces()) {
            if (i != List.class) continue;
            return true;
        }
        return false;
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        ArrayList<DhcpIpAddress> dhcpIpAddresses = new ArrayList<DhcpIpAddress>();
        String name = null;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            DhcpIpAddress dhcpIpAddress = new DhcpIpAddress();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                name = reader.getNodeName();
                if (name.equals(ELEMENT_IP_ADDRESS)) {
                    dhcpIpAddress.setIpAddress(reader.getValue());
                } else if (name.equals(ELEMENT_MAC_ADDRESS)) {
                    dhcpIpAddress.setMacAddress(reader.getValue());
                } else if (name.equals(ELEMENT_LEASE_TYPE)) {
                    dhcpIpAddress.setLeaseType(reader.getValue());
                } else if (name.equals(ELEMENT_LEASE_EXPIRATION)) {
                    dhcpIpAddress.setLeaseExpiration(DateUtils.toDate(reader.getValue()));
                } else if (name.equals(ELEMENT_CLIENT_NAME)) {
                    dhcpIpAddress.setClientName(reader.getValue());
                } else if (name.equals(ELEMENT_DESCRIPTION)) {
                    dhcpIpAddress.setDescription(reader.getValue());
                }
                reader.moveUp();
            }
            dhcpIpAddresses.add(dhcpIpAddress);
            reader.moveUp();
        }
        return dhcpIpAddresses;
    }

    public void marshal(Object paramObject, HierarchicalStreamWriter paramHierarchicalStreamWriter, MarshallingContext paramMarshallingContext) {
    }
}

