/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.dhcp.model.transform;

import com.nifty.cloud.sdk.dhcp.model.DhcpConfiguration;
import com.nifty.cloud.sdk.dhcp.model.transform.ValueSetConverter;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.ArrayList;
import java.util.List;

public class DhcpConfigurationSetConverter
implements Converter {
    private static final String ELEMENT_KEY = "key";
    private static final String ELEMENT_VALUE_SET = "valueSet";

    public boolean canConvert(Class clazz) {
        Class<?>[] interfaces;
        for (Class<?> i : interfaces = clazz.getInterfaces()) {
            if (i != List.class) continue;
            return true;
        }
        return false;
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        ArrayList<DhcpConfiguration> dhcpConfigurations = new ArrayList<DhcpConfiguration>();
        ValueSetConverter valueSetConverter = new ValueSetConverter();
        String name = null;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            DhcpConfiguration dhcpConfiguration = new DhcpConfiguration();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                name = reader.getNodeName();
                if (name.equals(ELEMENT_KEY)) {
                    dhcpConfiguration.setKey(reader.getValue());
                } else if (name.equals(ELEMENT_VALUE_SET)) {
                    dhcpConfiguration.setValues((List)valueSetConverter.unmarshal(reader, context));
                }
                reader.moveUp();
            }
            dhcpConfigurations.add(dhcpConfiguration);
            reader.moveUp();
        }
        return dhcpConfigurations;
    }

    public void marshal(Object paramObject, HierarchicalStreamWriter paramHierarchicalStreamWriter, MarshallingContext paramMarshallingContext) {
    }
}

